/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.event;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.AbstractWorkflowEvent;
import com.atlassian.jira.event.DraftWorkflowCreatedEvent;
import com.atlassian.jira.event.DraftWorkflowPublishedEvent;
import com.atlassian.jira.event.WorkflowCopiedEvent;
import com.atlassian.jira.event.WorkflowDeletedEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.sysbliss.jira.plugins.workflow.event.WorkflowLayoutHousekeeper;
import com.sysbliss.jira.plugins.workflow.manager.CachingWorkflowImageManagerImpl;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowAnnotationManager;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowImageManager;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowLayoutManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;

public class WorkflowLayoutHousekeeperImpl
implements WorkflowLayoutHousekeeper,
LifecycleAware,
DisposableBean {
    public static Logger log = Logger.getLogger(WorkflowLayoutHousekeeperImpl.class);
    private final EventPublisher eventPublisher;
    private final WorkflowLayoutManager workflowLayoutManager;
    private final WorkflowAnnotationManager workflowAnnotationManager;
    private final WorkflowImageManager workflowImageManager;

    public WorkflowLayoutHousekeeperImpl(EventPublisher eventPublisher, WorkflowLayoutManager workflowLayoutManager, WorkflowImageManager workflowImageManager, WorkflowAnnotationManager workflowAnnotationManager) {
        this.eventPublisher = eventPublisher;
        this.workflowLayoutManager = workflowLayoutManager;
        this.workflowImageManager = workflowImageManager;
        this.workflowAnnotationManager = workflowAnnotationManager;
    }

    @EventListener
    public void onDraftWorkflowCreated(DraftWorkflowCreatedEvent event) throws Exception {
        this.workflowLayoutManager.copyLayoutForDraftWorkflow(event.getWorkflow().getName());
        this.workflowLayoutManager.copyNewLayoutForDraftWorkflow(event.getWorkflow().getName());
        this.workflowAnnotationManager.copyAnnotationsForDraftWorkflow(event.getWorkflow().getName());
    }

    @EventListener
    public void onDraftWorkflowPublished(DraftWorkflowPublishedEvent event) throws Exception {
        this.workflowLayoutManager.publishDraftLayout(event.getWorkflow().getName());
        this.workflowLayoutManager.publishNewDraftLayout(event.getWorkflow().getName());
        this.clearImageCache(event.getWorkflow().getName());
        this.workflowAnnotationManager.publishDraftAnnotations(event.getWorkflow().getName());
    }

    @EventListener
    public void onWorkflowCopied(WorkflowCopiedEvent event) throws Exception {
        this.workflowLayoutManager.copyActiveLayout(event.getOriginalWorkflow().getName(), event.getNewWorkflow().getName());
        this.workflowLayoutManager.copyNewActiveLayout(event.getOriginalWorkflow().getName(), event.getNewWorkflow().getName());
        this.workflowAnnotationManager.copyActiveAnnotations(event.getOriginalWorkflow().getName(), event.getNewWorkflow().getName());
    }

    @EventListener
    public void onWorkflowDeleted(WorkflowDeletedEvent event) {
        this.workflowLayoutManager.removeActiveLayout(event.getWorkflow().getName());
        this.workflowLayoutManager.removeNewActiveLayout(event.getWorkflow().getName());
    }

    @EventListener
    public void onDraftWorkflowDeleted(WorkflowDeletedEvent event) {
        this.workflowLayoutManager.removeDraftLayout(event.getWorkflow().getName());
        this.workflowLayoutManager.removeNewDraftLayout(event.getWorkflow().getName());
    }

    @EventListener
    public void onWorkflowRenamed(AbstractWorkflowEvent event) {
        if ("com.atlassian.jira.event.WorkflowRenamedEvent".equals(event.getClass().getName())) {
            try {
                String oldName = (String)event.getClass().getMethod("getOldWorkflowName", new Class[0]).invoke((Object)event, new Object[0]);
                String newName = (String)event.getClass().getMethod("getNewWorkflowName", new Class[0]).invoke((Object)event, new Object[0]);
                this.workflowLayoutManager.moveActiveLayout(oldName, newName);
                this.workflowLayoutManager.moveNewActiveLayout(oldName, newName);
            }
            catch (Exception e) {
                log.error((Object)"Error occurred while handling workflow renaming", (Throwable)e);
            }
        }
    }

    protected void clearImageCache(String workflowName) {
        if (this.workflowImageManager instanceof CachingWorkflowImageManagerImpl) {
            ((CachingWorkflowImageManagerImpl)this.workflowImageManager).clearCacheForWorkflow(workflowName);
        }
    }

    public void onStart() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }
}

