/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.workflow;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Outcomes;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflows;
import org.apache.commons.lang3.StringUtils;

public class WorkflowGlobalTransitions {
    private final Workflows workflows;
    private final StatusManager statusManager;
    private final FieldScreenManager fieldScreenManager;

    public WorkflowGlobalTransitions(StatusManager statusManager, Workflows workflows, FieldScreenManager fieldScreenManager) {
        this.workflows = workflows;
        this.statusManager = statusManager;
        this.fieldScreenManager = fieldScreenManager;
    }

    public ServiceOutcome<Workflow> createGlobalTransition(String statusId, String workflowName, String globalTransitionName, String globalTransitionDescription, Long screenId) {
        Status status = this.statusManager.getStatus(statusId);
        ServiceOutcome<Workflow> verificationResult = this.verifyGlobalTransitionCanBeAdded(globalTransitionName, status, workflowName, screenId);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> result = workflow.addGlobalTransition(globalTransitionName, globalTransitionDescription, status, this.fieldScreenManager.getFieldScreen(screenId));
        if (!result.isValid()) {
            return result;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    public ServiceOutcome<Workflow> deleteGlobalTransition(String globalTransitionId, String workflowName) {
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return workflowOutcome;
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        ServiceOutcome<Workflow> result = workflow.deleteGlobalTransition(globalTransitionId);
        if (!result.isValid()) {
            return result;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    public ServiceOutcome<Workflow> updateGlobalTransition(int transitionId, String name, String description, Long screenId, String workflowName) {
        ServiceOutcome<Workflow> verificationResult = this.verifyGlobalTransitionCanBeUpdated(transitionId, name, workflowName, screenId);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> updateOutcome = workflow.updateGlobalTransition(transitionId, name, description, this.fieldScreenManager.getFieldScreen(screenId));
        if (!updateOutcome.isValid()) {
            return updateOutcome;
        }
        return this.workflows.saveWorkflow((Workflow)updateOutcome.getReturnedValue());
    }

    private ServiceOutcome<Workflow> verifyGlobalTransitionCanBeAdded(String name, Status status, String workflowName, Long screenId) {
        FieldScreen fieldScreen;
        if (status == null) {
            return Outcomes.errorOutcome("workflow.designer.status.not.found", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            return Outcomes.errorOutcome("workflow.designer.enter.a.name", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return Outcomes.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (workflow.isDuplicateGlobalTransitionName(name) || workflow.targetStatusHasExistingTransitionWithName(status, name)) {
            return Outcomes.errorOutcome("workflow.designer.transition.name.exists", new Object[0]);
        }
        if (!workflow.statusExistsOnWorkflow(status)) {
            return Outcomes.errorOutcome("workflow.designer.adding.global.transition.no.status", new Object[0]);
        }
        if (workflow.statusHasGlobalTransition(status)) {
            return Outcomes.errorOutcome("workflow.designer.adding.global.transition.duplicate", new Object[0]);
        }
        if (this.screenIdSet(screenId) && (fieldScreen = this.fieldScreenManager.getFieldScreen(screenId)) == null) {
            return Outcomes.errorOutcome("workflow.designer.transition.screen.not.found", new Object[0]);
        }
        return Outcomes.okOutcome(workflow);
    }

    public ServiceOutcome<Workflow> verifyGlobalTransitionCanBeUpdated(int transitionId, String name, String workflowName, Long screenId) {
        FieldScreen fieldScreen;
        if (StringUtils.isBlank((CharSequence)name)) {
            return Outcomes.errorOutcome("workflow.designer.enter.a.name", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return Outcomes.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.hasTransition(transitionId)) {
            return Outcomes.errorOutcome("workflow.designer.updating.transition.not.found", new Object[0]);
        }
        if (!name.equals(workflow.getTransitionName(transitionId)) && (workflow.isDuplicateGlobalTransitionName(name) || workflow.targetStatusHasExistingTransitionWithName(transitionId, name))) {
            return Outcomes.errorOutcome("workflow.designer.transition.name.exists", new Object[0]);
        }
        if (this.screenIdSet(screenId) && (fieldScreen = this.fieldScreenManager.getFieldScreen(screenId)) == null) {
            return Outcomes.errorOutcome("workflow.designer.transition.screen.not.found", new Object[0]);
        }
        return Outcomes.okOutcome(workflow);
    }

    private boolean screenIdSet(Long screenId) {
        return screenId != null && screenId != 0L;
    }
}

