/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.workflow;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Outcomes;
import com.atlassian.jira.plugins.workflowdesigner.workflow.TransitionData;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflows;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.Collection;
import org.apache.log4j.Logger;

public class TransitionLoopExpander {
    private static final Logger LOG = Logger.getLogger(TransitionLoopExpander.class);
    private final FieldScreenManager fieldScreenManager;
    private final Workflows workflows;

    public TransitionLoopExpander(FieldScreenManager fieldScreenManager, Workflows workflows) {
        this.fieldScreenManager = fieldScreenManager;
        this.workflows = workflows;
    }

    public ServiceOutcome<Workflow> expandLoopsUpdatingDraftAndReturningModifiedWorkflow(Workflow workflow) {
        if (workflow.isSystemWorkflow()) {
            return Outcomes.okOutcome(workflow);
        }
        if (!workflow.isDraftWorkflow()) {
            workflow = workflow.isActive() ? this.workflows.getClone(workflow.getName()) : this.workflows.getMutableWorkflowWithoutValidation(workflow.getName());
        }
        Collection<ActionDescriptor> globalTransitions = this.findGlobalTransitionsWithLoops(workflow);
        Collection<ActionDescriptor> commonTransitions = this.findCommonTransitionsWithLoops(workflow);
        if (globalTransitions.isEmpty() && commonTransitions.isEmpty()) {
            return Outcomes.okOutcome(workflow);
        }
        ServiceOutcome<Workflow> globalExpansionResult = this.expandGlobalTransitionLoops(workflow, globalTransitions);
        if (!globalExpansionResult.isValid()) {
            return globalExpansionResult;
        }
        ServiceOutcome<Workflow> commonExpansionResult = this.expandCommonTransitionLoops(workflow, commonTransitions);
        if (!commonExpansionResult.isValid()) {
            return commonExpansionResult;
        }
        if (!workflow.isActive() || workflow.isDraftWorkflow()) {
            return this.workflows.saveWorkflow(workflow);
        }
        return Outcomes.okOutcome(workflow);
    }

    private ServiceOutcome<Workflow> expandGlobalTransitionLoops(Workflow workflow, Collection<ActionDescriptor> globalTransitions) {
        ServiceOutcome<Workflow> removalResult = this.removeGlobalTransitionsWithLoops(workflow, globalTransitions);
        if (!removalResult.isValid()) {
            LOG.warn((Object)"There was a problem removing the global transition loops from the workflow.");
            return removalResult;
        }
        ServiceOutcome<Workflow> expansionResult = this.addNormalTransitionLoopsToEachStatus(workflow, globalTransitions);
        if (!expansionResult.isValid()) {
            LOG.warn((Object)"There was a problem adding the new transition loops to the workflow to replace the global transition loop.");
            return expansionResult;
        }
        return Outcomes.okOutcome(workflow);
    }

    private ServiceOutcome<Workflow> addNormalTransitionLoopsToEachStatus(Workflow workflow, Collection<ActionDescriptor> globalTransitions) {
        for (ActionDescriptor loop : globalTransitions) {
            FieldScreen screen = this.lookupScreen(loop);
            for (StepDescriptor step : workflow.getSteps()) {
                ServiceOutcome<Workflow> addTransitionResult = this.addTransitionAndCopyData(workflow, loop, step, screen);
                if (addTransitionResult.isValid()) continue;
                return addTransitionResult;
            }
        }
        return Outcomes.okOutcome(workflow);
    }

    private ServiceOutcome<Workflow> expandCommonTransitionLoops(Workflow workflow, Collection<ActionDescriptor> commonTransitions) {
        for (ActionDescriptor loop : commonTransitions) {
            FieldScreen screen = this.lookupScreen(loop);
            for (StepDescriptor step : workflow.getStepsForTransition(loop)) {
                ServiceOutcome<Workflow> deleteLoopResult = workflow.deleteTransition(loop.getId(), step.getId());
                if (!deleteLoopResult.isValid()) {
                    return deleteLoopResult;
                }
                ServiceOutcome<Workflow> addTransitionResult = this.addTransitionAndCopyData(workflow, loop, step, screen);
                if (addTransitionResult.isValid()) continue;
                return addTransitionResult;
            }
        }
        return Outcomes.okOutcome(workflow);
    }

    private ServiceOutcome<Workflow> addTransitionAndCopyData(Workflow workflow, ActionDescriptor loop, StepDescriptor step, FieldScreen screen) {
        ServiceOutcome<TransitionData> addTransitionResult = workflow.addTransition(loop.getName(), "", screen, step.getId(), step.getId());
        if (addTransitionResult.isValid()) {
            TransitionData transitionData = (TransitionData)addTransitionResult.getReturnedValue();
            ActionDescriptor transition = workflow.getDescriptor().getAction(transitionData.getActionId());
            this.copyPostFunctions(loop, transition);
            this.copyConditions(loop, transition);
            this.copyValidators(loop, transition);
            this.copyProperties(loop, transition);
        } else if (!this.addingTransitionFailedDueToWorkflowLimitations(addTransitionResult)) {
            return Outcomes.errorOutcome(addTransitionResult.getErrorCollection());
        }
        return Outcomes.okOutcome(workflow);
    }

    private void copyProperties(ActionDescriptor loop, ActionDescriptor transition) {
        transition.getMetaAttributes().clear();
        transition.getMetaAttributes().putAll(loop.getMetaAttributes());
    }

    private void copyValidators(ActionDescriptor loop, ActionDescriptor transition) {
        transition.getValidators().clear();
        transition.getValidators().addAll(loop.getValidators());
    }

    private void copyConditions(ActionDescriptor loop, ActionDescriptor transition) {
        transition.setRestriction(loop.getRestriction());
    }

    private void copyPostFunctions(ActionDescriptor loop, ActionDescriptor transition) {
        transition.getUnconditionalResult().getPostFunctions().clear();
        transition.getUnconditionalResult().getPostFunctions().addAll(loop.getUnconditionalResult().getPostFunctions());
    }

    private boolean addingTransitionFailedDueToWorkflowLimitations(ServiceOutcome<TransitionData> result) {
        return result.getErrorCollection().getErrorMessages().contains(Outcomes.getText("workflow.designer.forbidden.operation.draft.workflow", "<a target=\"_blank\" href=\"https://confluence.atlassian.com/display/JIRA/Configuring+Workflow#ConfiguringWorkflow-Limitationswheneditinganactiveworkflow\">", "</a>"));
    }

    private FieldScreen lookupScreen(ActionDescriptor globalTransitionWithLoop) {
        FieldScreen fieldScreen = null;
        String screenId = (String)globalTransitionWithLoop.getMetaAttributes().get("jira.fieldscreen.id");
        if (screenId != null) {
            try {
                fieldScreen = this.fieldScreenManager.getFieldScreen(Long.valueOf(screenId));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("lookupScreen - couldn't parse:" + screenId + " as a number, ignoring and won't set a screen."));
            }
        }
        return fieldScreen;
    }

    private ServiceOutcome<Workflow> removeGlobalTransitionsWithLoops(Workflow workflow, Collection<ActionDescriptor> globalTransitionsWithLoops) {
        for (ActionDescriptor globalTransitionWithLoop : globalTransitionsWithLoops) {
            ServiceOutcome<Workflow> result = workflow.deleteGlobalTransition(String.valueOf(globalTransitionWithLoop.getId()));
            if (result.isValid()) continue;
            return result;
        }
        return Outcomes.okOutcome(workflow);
    }

    private Collection<ActionDescriptor> findGlobalTransitionsWithLoops(Workflow workflow) {
        return this.findTransitionsWithLoops(workflow.getDescriptor().getGlobalActions());
    }

    private Collection<ActionDescriptor> findCommonTransitionsWithLoops(Workflow workflow) {
        return this.findTransitionsWithLoops(workflow.getDescriptor().getCommonActions().values());
    }

    private Collection<ActionDescriptor> findTransitionsWithLoops(Collection<ActionDescriptor> transitions) {
        return Lists.newArrayList((Iterable)Collections2.filter(transitions, (Predicate)new Predicate<ActionDescriptor>(){

            public boolean apply(ActionDescriptor transition) {
                return transition.getUnconditionalResult().getStep() == -1;
            }
        }));
    }
}

