/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.utilities;

import com.atlassian.jira.plugins.workflowdesigner.workflow.TransitionData;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.sysbliss.jira.plugins.workflow.util.MetadataUtils;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ActionDescriptorTransitionData
implements TransitionData {
    private final ActionDescriptor actionDescriptor;

    public ActionDescriptorTransitionData(ActionDescriptor actionDescriptor) {
        this.actionDescriptor = actionDescriptor;
    }

    @Override
    public int getActionId() {
        return this.actionDescriptor.getId();
    }

    @Override
    public String getName() {
        return this.actionDescriptor.getName();
    }

    @Override
    public String getDescription() {
        return (String)this.actionDescriptor.getMetaAttributes().get("jira.description");
    }

    @Override
    public Long getScreenId() {
        String screenId = (String)this.actionDescriptor.getMetaAttributes().get("jira.fieldscreen.id");
        return StringUtils.isBlank((String)screenId) ? null : Long.valueOf(screenId);
    }

    @Override
    public String getScreenName() {
        return this.actionDescriptor.getView();
    }

    @Override
    public int getPropertiesCount() {
        return Sets.filter(this.actionDescriptor.getMetaAttributes().keySet(), (Predicate)Predicates.not((Predicate)new Predicate<String>(){

            public boolean apply(String propertyKey) {
                return MetadataUtils.isReservedKey(propertyKey);
            }
        })).size();
    }

    @Override
    public int getConditionsCount() {
        RestrictionDescriptor restriction = this.actionDescriptor.getRestriction();
        if (restriction != null) {
            return this.getNumberOfConditions(restriction.getConditionsDescriptor());
        }
        return 0;
    }

    private int getNumberOfConditions(ConditionsDescriptor conditionsDescriptor) {
        List conditions;
        int number = 0;
        if (conditionsDescriptor != null && (conditions = conditionsDescriptor.getConditions()) != null) {
            for (Object o : conditions) {
                if (o instanceof ConditionDescriptor) {
                    ++number;
                    continue;
                }
                if (!(o instanceof ConditionsDescriptor)) continue;
                number += this.getNumberOfConditions((ConditionsDescriptor)o);
            }
        }
        return number;
    }

    @Override
    public int getValidatorsCount() {
        return this.actionDescriptor.getValidators().size();
    }

    @Override
    public int getPostFunctionsCount() {
        if (this.actionDescriptor.getUnconditionalResult() == null || this.actionDescriptor.getUnconditionalResult().getPostFunctions() == null) {
            return 0;
        }
        return this.actionDescriptor.getUnconditionalResult().getPostFunctions().size();
    }
}

