/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.rest;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.workflowdesigner.rest.Responses;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.WorkflowStatuses;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/workflows/statuses")
public class WorkflowStatusesResource {
    private final StatusManager statusManager;
    private final WorkflowStatuses statuses;
    private final Responses responses;

    public WorkflowStatusesResource(StatusManager statusManager, WorkflowStatuses statuses, Responses responses) {
        this.statusManager = statusManager;
        this.statuses = statuses;
        this.responses = responses;
    }

    @POST
    @Produces(value={"application/json"})
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response addStatus(@FormParam(value="createGlobalTransition") boolean createGlobalTransition, @FormParam(value="statusId") String statusId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> result;
        Status status = this.statusManager.getStatus(statusId);
        if (status == null) {
            return this.responses.createResponse("workflow.designer.status.not.found", Response.Status.BAD_REQUEST);
        }
        ServiceOutcome<Workflow> serviceOutcome = result = createGlobalTransition ? this.statuses.addStatusAndGlobalTransitionToWorkflow(status, workflowName) : this.statuses.addStatusToWorkflow(status, workflowName);
        if (!result.isValid()) {
            return Responses.createErrorResponse(result, Response.Status.BAD_REQUEST);
        }
        return this.responses.getWorkflowLayoutResponse((JiraWorkflow)result.getReturnedValue(), "workflow.designer.add.status.failed");
    }

    @Path(value="/create")
    @POST
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response createAndAddStatus(@FormParam(value="createGlobalTransition") boolean createGlobalTransition, @FormParam(value="description") String description, @FormParam(value="name") String name, @FormParam(value="statusCategoryId") String statusCategoryId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> result = this.statuses.createAndAddStatusToWorkflow(createGlobalTransition, description, name, statusCategoryId, workflowName);
        if (!result.isValid()) {
            return Responses.createErrorResponse(result, Response.Status.BAD_REQUEST);
        }
        return this.responses.getWorkflowLayoutResponse((JiraWorkflow)result.getReturnedValue(), "workflow.designer.create.status.failed");
    }

    @DELETE
    @Produces(value={"application/json"})
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response removeStatus(@FormParam(value="statusId") String statusId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> outcome = this.statuses.removeStatus(statusId, workflowName);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return this.responses.getWorkflowLayoutResponse((JiraWorkflow)outcome.getReturnedValue(), "workflow.designer.remove.status.failed");
    }

    @PUT
    @Produces(value={"application/json"})
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response updateStatus(@FormParam(value="description") String description, @FormParam(value="name") String name, @FormParam(value="statusCategoryId") String statusCategoryId, @FormParam(value="statusId") String statusId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> outcome = this.statuses.updateStatus(description, name, statusCategoryId, statusId, workflowName);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return Responses.createOKResponse();
    }
}

