/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.rest;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.plugins.workflowdesigner.rest.Responses;
import com.atlassian.jira.plugins.workflowdesigner.rest.StatusCategory;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="/statusCategories")
@Produces(value={"application/json"})
public class StatusCategoriesResource {
    private final JiraAuthenticationContext authenticationContext;
    private final ConstantsService constantsService;
    private final I18nHelper i18nHelper;
    private final Function<com.atlassian.jira.issue.status.category.StatusCategory, StatusCategory> transformStatusCategory = new Function<com.atlassian.jira.issue.status.category.StatusCategory, StatusCategory>(){

        public StatusCategory apply(com.atlassian.jira.issue.status.category.StatusCategory statusCategory) {
            String nameKey = "common.statuscategory." + statusCategory.getKey();
            return new StatusCategory(statusCategory.getColorName(), statusCategory.getId(), statusCategory.getKey(), StatusCategoriesResource.this.i18nHelper.getText(nameKey));
        }
    };

    public StatusCategoriesResource(JiraAuthenticationContext authenticationContext, ConstantsService constantsService, I18nHelper i18nHelper) {
        this.authenticationContext = authenticationContext;
        this.constantsService = constantsService;
        this.i18nHelper = i18nHelper;
    }

    @GET
    public Response getStatusCategories() {
        ServiceOutcome outcome = this.constantsService.getAllStatusCategories(this.getCurrentUser());
        if (!outcome.isValid()) {
            ErrorCollection errorCollection = ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)outcome.getErrorCollection());
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errorCollection).cacheControl(CacheControl.never()).build();
        }
        ArrayList statusCategories = Lists.newArrayList((Iterable)((Iterable)outcome.getReturnedValue()));
        return Responses.createOKResponse(Lists.transform((List)statusCategories, this.transformStatusCategory));
    }

    private User getCurrentUser() {
        ApplicationUser user = this.authenticationContext.getUser();
        return user == null ? null : user.getDirectoryUser();
    }
}

