/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.webhooks.ao.WebhookDao;
import com.atlassian.jira.plugins.webhooks.matcher.Event;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class Task002
implements PluginUpgradeTask {
    private final ActiveObjects ao;
    private final Set<String> allEvents;

    public Task002(ActiveObjects ao) {
        this.ao = (ActiveObjects)Preconditions.checkNotNull((Object)ao);
        this.allEvents = Sets.newHashSet((Object[])new String[]{"jira:issue_created", "jira:issue_deleted", "jira:issue_updated", "jira:worklog_updated"});
    }

    public int getBuildNumber() {
        return 2;
    }

    public String getShortDescription() {
        return "This task translates all events into the proper event list";
    }

    public Collection<Message> doUpgrade() throws Exception {
        WebhookDao[] webhookDaos;
        for (WebhookDao webhookDao : webhookDaos = (WebhookDao[])this.ao.find(WebhookDao.class)) {
            String[] events = webhookDao.getEvents();
            if (events != null && events.length == 1) {
                if (events[0].equals(Event.ALL_EVENTS.getValue())) {
                    webhookDao.setEvents(this.allEvents.toArray(new String[this.allEvents.size()]));
                } else if (events[0].equals(Event.NO_EVENTS.getValue())) {
                    webhookDao.setEvents(new String[0]);
                }
            }
            webhookDao.save();
        }
        return Collections.emptyList();
    }

    public String getPluginKey() {
        return "com.atlassian.jira.plugins.webhooks.jira-webhooks-plugin";
    }
}

