/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.templates;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugins.webhooks.templates.InvalidTemplateException;
import com.atlassian.uri.Uri;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlBuilder {
    public static final String ISSUE_KEY_TEMPLATE = "issue.key";
    private final Pattern encodedPattern = Pattern.compile("(\\$%7B)(\\w+\\.\\w+)(%7D)");
    private final Pattern decodedPattern = Pattern.compile("(\\$\\{)(\\w+\\.\\w+)(\\})");

    public static String escapeIssueKeyTemplate(String path) {
        return path.replaceAll("(\\{)", "%7B").replaceAll("(\\})", "%7D");
    }

    public URI buildUrl(URI templateUrl, Issue issue) throws InvalidTemplateException {
        return this.buildUrl(templateUrl, issue.getKey());
    }

    public URI buildUrl(URI templateUrl, String issueKey) throws InvalidTemplateException {
        String targetUrl = this.applyTemplates(templateUrl.toString(), (Map<String, String>)this.populateTemplates(issueKey), this.encodedPattern);
        return Uri.parse(targetUrl).toJavaUri();
    }

    public String getSampleUrl(String templateUrl) throws InvalidTemplateException {
        String sampleIssueKey = "TST-12345";
        ImmutableMap templates = ImmutableMap.of((Object)ISSUE_KEY_TEMPLATE, (Object)"TST-12345");
        return this.applyTemplates(templateUrl, (Map<String, String>)templates, this.decodedPattern);
    }

    private ImmutableMap<String, String> populateTemplates(String issueKey) {
        try {
            return ImmutableMap.builder().put((Object)ISSUE_KEY_TEMPLATE, (Object)URLEncoder.encode(issueKey, "UTF-8")).build();
        }
        catch (UnsupportedEncodingException e) {
            return ImmutableMap.builder().put((Object)ISSUE_KEY_TEMPLATE, (Object)issueKey).build();
        }
    }

    private String applyTemplates(String templateUrl, Map<String, String> replacements, Pattern pattern) throws InvalidTemplateException {
        Matcher matcher = pattern.matcher(templateUrl);
        String replacedUrl = templateUrl;
        while (matcher.find()) {
            replacedUrl = this.applyTemplate(replacedUrl, replacements, pattern);
        }
        return replacedUrl;
    }

    private String applyTemplate(String templateUrl, Map<String, String> replacements, Pattern pattern) throws InvalidTemplateException {
        Matcher matcher = pattern.matcher(templateUrl);
        if (matcher.find()) {
            String template = matcher.group(2);
            String replacement = replacements.get(template);
            if (replacement == null) {
                throw new InvalidTemplateException("The following template is invalid " + template);
            }
            return matcher.replaceFirst(replacement);
        }
        return templateUrl;
    }
}

