/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.serializer;

import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.issue.fields.rest.json.CommentBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.plugins.webhooks.mapper.EventMapper;
import com.atlassian.jira.plugins.webhooks.mapper.EventTypeInfoDecorator;
import com.atlassian.jira.plugins.webhooks.mapper.IssueBeanFactory;
import com.atlassian.jira.plugins.webhooks.mapper.IssueEventMapper;
import com.atlassian.jira.plugins.webhooks.mapper.IssuePreDeleteEventMapper;
import com.atlassian.jira.plugins.webhooks.matcher.WebHookJiraEvent;
import com.atlassian.jira.plugins.webhooks.serializer.JacksonEventSerializer;
import com.atlassian.jira.plugins.webhooks.serializer.MapEventSerializer;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.webhooks.spi.provider.EventSerializer;
import com.atlassian.webhooks.spi.provider.EventSerializerFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraEventSerializerFactory
implements EventSerializerFactory<JiraEvent> {
    private static final Logger log = LoggerFactory.getLogger(JiraEventSerializerFactory.class);
    protected final List<EventMapper<JiraEvent>> mappers;
    private final ImmutableList<WebHookJiraEvent> webhooksJiraEvents = ImmutableList.copyOf((Object[])WebHookJiraEvent.values());

    public JiraEventSerializerFactory(CommentBeanFactory commentBeanFactory, UserBeanFactory userBeanFactory, BeanBuilderFactory restBeanBuilderFactory, IssueBeanFactory issueBeanFactory) {
        this.mappers = ImmutableList.of((Object)new IssueEventMapper(commentBeanFactory, userBeanFactory, restBeanBuilderFactory, issueBeanFactory), (Object)new IssuePreDeleteEventMapper(userBeanFactory, issueBeanFactory));
    }

    public EventSerializer create(JiraEvent event) {
        for (EventMapper<JiraEvent> mapper : this.mappers) {
            if (!mapper.handles(event)) continue;
            return new JacksonEventSerializer(event, new EventTypeInfoDecorator(mapper, this.getWebhooksJiraEvents()).toMap(event));
        }
        log.warn(String.format("Event %s was not recognised by any Event to WebHook mapper.", event.getClass().getName()));
        return new MapEventSerializer(event, (Map<String, Object>)ImmutableMap.builder().build());
    }

    public Iterable<WebHookJiraEvent> getWebhooksJiraEvents() {
        return this.webhooksJiraEvents;
    }
}

