/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.serializer;

import com.atlassian.plugins.rest.common.json.JacksonJsonProviderFactory;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.webhooks.spi.provider.EventSerializer;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.ObjectMapper;

public class JacksonEventSerializer
implements EventSerializer {
    private final Object event;
    private final Map<String, Object> data;
    private final JacksonJsonProvider provider;
    private final LazyReference<String> json;

    public JacksonEventSerializer(Object event, final Map<String, Object> data) {
        this.event = event;
        this.data = data;
        this.provider = new JacksonJsonProviderFactory().create();
        this.json = new LazyReference<String>(){

            protected String create() throws Exception {
                ObjectMapper mapper = JacksonEventSerializer.this.provider.locateMapper(data.getClass(), MediaType.APPLICATION_JSON_TYPE);
                return mapper.writeValueAsString((Object)data);
            }
        };
    }

    public Object getEvent() {
        return this.event;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public String getWebHookBody() {
        return (String)this.json.get();
    }
}

