/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.mapper;

import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.event.issue.IssuePreDeleteEvent;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.plugins.webhooks.mapper.IssueBeanFactory;
import com.atlassian.jira.plugins.webhooks.mapper.JiraEventMapper;
import com.google.common.collect.ImmutableMap;

public class IssuePreDeleteEventMapper
extends JiraEventMapper {
    private final UserBeanFactory userBeanFactory;
    private final IssueBeanFactory issueBeanFactory;

    public IssuePreDeleteEventMapper(UserBeanFactory userBeanFactory, IssueBeanFactory issueBeanFactory) {
        this.userBeanFactory = userBeanFactory;
        this.issueBeanFactory = issueBeanFactory;
    }

    @Override
    public boolean handles(JiraEvent e) {
        return e instanceof IssuePreDeleteEvent;
    }

    @Override
    protected ImmutableMap.Builder<String, Object> mapEvent(JiraEvent event) {
        IssuePreDeleteEvent preDeleteEvent = (IssuePreDeleteEvent)event;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (preDeleteEvent.getUser() != null) {
            builder.put((Object)"user", (Object)this.userBeanFactory.createBean(preDeleteEvent.getUser()));
        }
        builder.put((Object)"issue", (Object)this.issueBeanFactory.createBean(preDeleteEvent.getIssue()));
        return builder;
    }
}

