/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.mapper;

import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.fields.rest.json.CommentBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.plugins.webhooks.mapper.IssueBeanFactory;
import com.atlassian.jira.plugins.webhooks.mapper.JiraEventMapper;
import com.atlassian.jira.rest.v2.issue.ChangelogBean;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.issue.builder.ChangelogBeanBuilder;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;

public class IssueEventMapper
extends JiraEventMapper {
    private final CommentBeanFactory commentBeanFactory;
    private final UserBeanFactory userBeanFactory;
    private final BeanBuilderFactory restBeanBuilderFactory;
    private final IssueBeanFactory issueBeanFactory;
    private final Collection<Long> noChangeLogEventTypes = Lists.newArrayList((Object[])new Long[]{EventType.ISSUE_COMMENTED_ID, EventType.ISSUE_COMMENT_DELETED_ID, EventType.ISSUE_COMMENT_EDITED_ID, EventType.ISSUE_DELETED_ID});

    public IssueEventMapper(CommentBeanFactory commentBeanFactory, UserBeanFactory userBeanFactory, BeanBuilderFactory restBeanBuilderFactory, IssueBeanFactory issueBeanFactory) {
        this.commentBeanFactory = commentBeanFactory;
        this.userBeanFactory = userBeanFactory;
        this.restBeanBuilderFactory = restBeanBuilderFactory;
        this.issueBeanFactory = issueBeanFactory;
    }

    @Override
    public boolean handles(JiraEvent event) {
        return event instanceof IssueEvent;
    }

    @Override
    protected ImmutableMap.Builder<String, Object> mapEvent(JiraEvent event) {
        IssueEvent issueEvent = (IssueEvent)event;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (issueEvent.getUser() != null) {
            builder.put((Object)"user", (Object)this.userBeanFactory.createBean(issueEvent.getUser()));
        }
        builder.put((Object)"issue", (Object)this.issueBeanFactory.createBean(issueEvent.getIssue()));
        Optional<? extends ChangelogBean.ChangeHistoryBean> changelog = this.getChangelog(issueEvent);
        if (changelog.isPresent()) {
            builder.put((Object)"changelog", changelog.get());
        }
        if (issueEvent.getComment() != null) {
            builder.put((Object)"comment", (Object)this.commentBeanFactory.createBean(issueEvent.getComment()));
        }
        return builder;
    }

    private Optional<? extends ChangelogBean.ChangeHistoryBean> getChangelog(IssueEvent issueEvent) {
        ChangelogBeanBuilder changelogBeanBuilder = this.restBeanBuilderFactory.newChangelogBeanBuilder();
        List allChanges = changelogBeanBuilder.build(issueEvent.getIssue()).getHistories();
        if (this.noChangeLogEventTypes.contains(issueEvent.getEventTypeId())) {
            return Optional.absent();
        }
        if (allChanges.size() == 0) {
            return Optional.absent();
        }
        List histories = Lists.reverse((List)allChanges);
        ChangelogBean.ChangeHistoryBean changeHistoryBean = (ChangelogBean.ChangeHistoryBean)Iterables.find((Iterable)histories, IssueEventMapper.getPredicate(issueEvent), histories.get(0));
        return Optional.of((Object)((Object)new NoUserCHB(changeHistoryBean)));
    }

    private static Predicate<ChangelogBean.ChangeHistoryBean> getPredicate(final IssueEvent issueEvent) {
        if (issueEvent.getChangeLog() != null && issueEvent.getChangeLog().get("id") != null) {
            return new Predicate<ChangelogBean.ChangeHistoryBean>(){

                public boolean apply(@Nullable ChangelogBean.ChangeHistoryBean changeHistoryBean) {
                    if (changeHistoryBean == null) {
                        return false;
                    }
                    Long changeLogId = (Long)issueEvent.getChangeLog().get("id");
                    return Long.valueOf(changeHistoryBean.getId()).equals(changeLogId);
                }
            };
        }
        return new Predicate<ChangelogBean.ChangeHistoryBean>(){

            public boolean apply(@Nullable ChangelogBean.ChangeHistoryBean changeHistoryBean) {
                return changeHistoryBean != null && StringUtils.equals((String)issueEvent.getUser().getName(), (String)changeHistoryBean.getAuthor().getName());
            }
        };
    }

    static class NoUserCHB
    extends ChangelogBean.ChangeHistoryBean {
        private ChangelogBean.ChangeHistoryBean changeHistory;

        NoUserCHB(ChangelogBean.ChangeHistoryBean chb) {
            this.changeHistory = chb;
            this.setId(chb.getId());
            this.setItems(chb.getItems());
        }

        @JsonIgnore
        public UserJsonBean getAuthor() {
            return this.changeHistory.getAuthor();
        }

        @JsonIgnore
        public Date getCreated() {
            return this.changeHistory.getCreated();
        }
    }
}

