define('jira/project-templates/create-shared-controller-impl', [
    'jira/project-templates/add-project-controller',
    'jira/project-templates/create-shared-view',
    'jira/lib/class',
    'jquery',
    'underscore'
], function(
    AddProjectController,
    CreateSharedView,
    Class,
    $,
    _
) {
    "use strict";

    var contextPath = AJS.contextPath();

    return Class.extend({

        init: function (options) {
            this._window = options.window || window; // used for mocking 'window' in QUnit
            _.bindAll(this, "dialogSubmitted");
        },

        initCreateShared: function () {
            CreateSharedView.prepareDialog(AJS.I18n.getText('add.project.dialog.create.shared'));

            var self = this;
            this._getProjectSuggestions().done(function (resp) {
                if (self._hasSuggestions(resp)) {
                    CreateSharedView.draw({projectSuggestions: resp});
                } else {
                    CreateSharedView.drawEmptyInfo();
                }
            }).fail(function () {
                CreateSharedView.drawError(AJS.I18n.getText("add.projects.templates.error.requestfailed.msg"));
            });

            CreateSharedView.drawLoading();
        },

        _hasSuggestions: function (projectSuggestions) {
            var hasSuggestions = false;
            $.each(projectSuggestions, function (i, group) {
                if (group && group.items && group.items.length > 0) {
                    hasSuggestions = true;
                }
            });
            return hasSuggestions;
        },

        _getProjectSuggestions: function () {
            return $.ajax({
                url: contextPath + "/rest/project-templates/1.0/createshared"
            });
        },

        dialogSubmitted: function () {
            var selectedProject = CreateSharedView.getSelectedProject();
            if (selectedProject) {
                AddProjectController.initCreateShared({existingProjectId: selectedProject});
            } else {
                CreateSharedView.showProjectMissingError();
            }
        }
    });
});
define('jira/project-templates/create-shared-controller', [
    'jira/project-templates/create-shared-controller-impl',
    'jquery'
], function(
    CreateSharedControllerImpl,
    $
){
    return new CreateSharedControllerImpl({el: $(document)});
});
AJS.namespace('JPT.CreateSharedController', null, require('jira/project-templates/create-shared-controller'));