AJS.test.require(["com.atlassian.jira.project-templates-plugin:test-resources"], function(){
    "use strict";
    var clock;

    module("JPT.AddProjectView", {
        setup: function() {
            this.el = jQuery('<div></div>').appendTo('#qunit-fixture');
            this.server = sinon.fakeServer.create();
            clock = sinon.useFakeTimers();
            this.fakeWindow = {};
            this.mockedModules = AJS.test.mockableModuleContext();

            var DialogViewImpl = require('jira/project-templates/dialog-view-impl');
            this.mockedModules.mock('jira/project-templates/dialog-view', new DialogViewImpl({ el: this.el }));

            var DialogController = require('jira/project-templates/dialog-controller');
            DialogController.dialog = this.mockedModules.require('jira/project-templates/dialog-view').draw();
            DialogController.$dialogElement = DialogController.dialog.popup.element;
            this.mockedModules.mock('jira/project-templates/dialog-controller', DialogController);

            var AddProjectViewImpl = this.mockedModules.require('jira/project-templates/add-project-view-impl');

            var AddProjectControllerImpl = this.mockedModules.require('jira/project-templates/add-project-controller-impl');
            this.mockedModules.mock('jira/project-templates/dialog-view', new DialogViewImpl({ el: this.el }));
            this.mockedModules.mock('jira/project-templates/add-project-view', new AddProjectViewImpl({
                el: this.el,
                dialogView: this.mockedModules.require('jira/project-templates/dialog-view')
            }));

            this.mockedModules.mock('jira/project-templates/add-project-controller', new AddProjectControllerImpl({
                el: this.el,
                window: this.fakeWindow
            }));

            // haven't had time to get rid of these globals yet
            JPT.ConfigModel = this.configModel = new JPT.test.MockConfigModel();

            // display the add project dialog
            this.addProjectView = this.mockedModules.require('jira/project-templates/add-project-view');
            this.addProjectView.prepareDialog();
            this.addProjectView.draw({
                webItemData: {
                    name: "Web Item Name",
                    description: "Web Item Description",
                    itemModuleCompleteKey: "itemModuleCompleteKey",
                    projectTemplateModuleCompleteKey: "projectTemplateModuleCompleteKey"
                },

                maxKeyLength: this.configModel.maxKeyLength,
                maxNameLength: this.configModel.maxNameLength,
                currentUserName: this.configModel.currentUserName,
                currentUserDisplayName: JPT.ConfigModel.currentUserDisplayName,
                currentUserAvatarUrl: JPT.ConfigModel.currentUserAvatarUrl,
                errors: {}
            });

            this.dialog = jQuery('#add-project-dialog');
            this.projectNameInput = this.dialog.find('#add-project-form input[id=name]');
            this.projectKeyInput = this.dialog.find('#add-project-form input[id=key]');
            this.addProjectController = this.mockedModules.require('jira/project-templates/add-project-controller');
        },

        teardown: function() {
            if(jQuery('#add-project-dialog').is(':visible'))
            {
                JPT.test.Keyboard.triggerEvent(this.projectNameInput, { keyCode: 27 }); // ESC
            }

            this.server.restore();
            clock.restore();
        }
    });

    test("pressing ESC cancels dialog", function () {
        var dialog = jQuery('#add-project-dialog');
        var projectNameInput = dialog.find('#add-project-form input[id=name]');
        this.addProjectController.validateName = sinon.stub(this.addProjectController, "validateName");

        // set the project name and tick the clock so that the key gets auto-generated
        projectNameInput.val("My Project");

        JPT.test.Keyboard.triggerEvent(projectNameInput, { keyCode: 27 }); // ESC
        ok(!dialog.is(':visible'), 'dialog is closed when user presses ESC');
        this.addProjectController.validateName.restore();
    });

    test("should convert manually entered key values to upper case when getKey is called", function() {
        var string = "some lowercase string";
        this.projectKeyInput.val(string);

        strictEqual(this.addProjectView.getKey(), string.toUpperCase(), "Lower case key values should be converted to upper case.");
        // Clean up the input so that JIRA doesn't try to warn us if we navigate away from the page
        this.projectKeyInput.val('');
    });

    test("should validate project name on element change", function() {
        sinon.stub(this.addProjectController, 'validateName');

        this.projectNameInput.change();

        sinon.assert.calledOnce(this.addProjectController.validateName);
        // Clean up and restore
        this.addProjectController.validateName.restore();
    });


    test("should validate project key on element change", function() {
        sinon.stub(this.addProjectController, 'validateName');
        sinon.stub(this.addProjectController, 'autofillKeyIfNeeded');
        sinon.stub(this.addProjectController, 'validateKey');

        this.projectKeyInput.change();

        sinon.assert.calledOnce(this.addProjectController.validateKey);
        // Clean up and restore
        this.addProjectController.validateName.restore();
        this.addProjectController.validateKey.restore();
        this.addProjectController.autofillKeyIfNeeded.restore();
    });

});


