/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.group.GroupService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.projecttemplates.service.ProjectLicenseService;
import com.atlassian.jira.user.ApplicationUser;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ProjectLicenseServiceImpl
implements ProjectLicenseService {
    private final ProjectTypeManager projectTypeManager;
    private final ApplicationAuthorizationService applicationAuthorizationService;
    private final ApplicationRoleManager applicationRoleManager;
    private final GroupService groupService;
    private final UserService userService;

    public ProjectLicenseServiceImpl(UserService userService, ProjectTypeManager projectTypeManager, ApplicationAuthorizationService applicationAuthorizationService, ApplicationRoleManager applicationRoleManager, GroupService groupService) {
        this.userService = userService;
        this.projectTypeManager = projectTypeManager;
        this.applicationAuthorizationService = applicationAuthorizationService;
        this.applicationRoleManager = applicationRoleManager;
        this.groupService = groupService;
    }

    @Override
    public boolean userCanBeAddedToApplication(ApplicationUser currentUser, ProjectTypeKey projectTypeKey, ApplicationUser userToAdd) {
        Option<Application> application = this.getApplicationForProjectTypeKey(projectTypeKey);
        if (application.isEmpty()) {
            return false;
        }
        Set defaultGroups = this.applicationRoleManager.getDefaultGroups(((Application)application.get()).getKey());
        if (defaultGroups.size() < 1) {
            return false;
        }
        List defaultGroupNames = defaultGroups.stream().map(Group::getName).collect(Collectors.toList());
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(currentUser);
        return this.groupService.validateAddUserToGroup((JiraServiceContext)jiraServiceContext, defaultGroupNames, userToAdd.getUsername());
    }

    @Override
    public boolean userCanUseApplication(ProjectTypeKey projectTypeKey, ApplicationUser user) {
        Option<Application> application = this.getApplicationForProjectTypeKey(projectTypeKey);
        if (application.isEmpty()) {
            return false;
        }
        ApplicationKey applicationKey = ((Application)application.get()).getKey();
        return this.applicationAuthorizationService.rolesEnabled() && this.applicationAuthorizationService.canUseApplication(user, applicationKey);
    }

    @Override
    public void addUserToLicense(ProjectTypeKey projectTypeKey, ApplicationUser user) throws AddException, PermissionException {
        Option<Application> application = this.getApplicationForProjectTypeKey(projectTypeKey);
        if (application.isEmpty()) {
            return;
        }
        UserService.AddUserToApplicationValidationResult addUserToApplicationValidationResult = this.userService.validateAddUserToApplication(user, ((Application)application.get()).getKey());
        this.userService.addUserToApplication(addUserToApplicationValidationResult);
    }

    @Override
    public Optional<Integer> getLicenseTotalSeats(ProjectTypeKey projectTypeKey) {
        Option<Application> application = this.getApplicationForProjectTypeKey(projectTypeKey);
        return Optional.ofNullable(application.map(Application::getKey).flatMap(arg_0 -> ((ApplicationRoleManager)this.applicationRoleManager).getRole(arg_0)).map(ApplicationRole::getNumberOfSeats).getOrNull());
    }

    @Override
    public Optional<Integer> getLicenseUsedSeats(ProjectTypeKey projectTypeKey) {
        Option<Application> application = this.getApplicationForProjectTypeKey(projectTypeKey);
        return Optional.ofNullable(application.map(Application::getKey).map(arg_0 -> ((ApplicationRoleManager)this.applicationRoleManager).getUserCount(arg_0)).getOrNull());
    }

    @Override
    public Optional<String> getApplicationName(ProjectTypeKey projectTypeKey) {
        Option<Application> application = this.getApplicationForProjectTypeKey(projectTypeKey);
        return Optional.ofNullable(application.map(Application::getName).getOrNull());
    }

    private Option<Application> getApplicationForProjectTypeKey(ProjectTypeKey projectTypeKey) {
        return this.projectTypeManager.getApplicationWithType(projectTypeKey);
    }
}

