/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.jira.blueprint.template.I18nTranslator;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugins.workflow.sharing.importer.JiraWorkflowSharingImporter;
import com.atlassian.jira.plugins.workflow.sharing.importer.SharedWorkflowImportPlan;
import com.atlassian.jira.plugins.workflow.sharing.importer.StatusMapping;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowBundle;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowImporterFactory;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowStatusHelper;
import com.atlassian.jira.plugins.workflow.sharing.model.StatusInfo;
import com.atlassian.jira.plugins.workflow.sharing.servlet.ValidationException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.template.hook.ConfigTemplate;
import com.atlassian.jira.project.template.hook.IssueTypeSchemeTemplate;
import com.atlassian.jira.project.template.hook.IssueTypeTemplate;
import com.atlassian.jira.project.template.hook.WorkflowSchemeTemplate;
import com.atlassian.jira.project.template.hook.WorkflowTemplate;
import com.atlassian.jira.projecttemplates.model.WorkflowSchemeCreationResult;
import com.atlassian.jira.projecttemplates.service.CustomWorkflowSchemeService;
import com.atlassian.jira.projecttemplates.service.NameResolver;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomWorkflowSchemeServiceImpl
implements CustomWorkflowSchemeService {
    private static final Logger LOG = LoggerFactory.getLogger(CustomWorkflowSchemeService.class);
    private final SharedWorkflowImportPlanFactoryHelper sharedWorkflowImportPlanFactoryHelper;
    private final WorkflowBundle.Factory workflowBundleFactory;
    private final WorkflowImporterFactory workflowImporterFactory;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final WorkflowManager workflowManager;
    private final WorkflowStatusHelper workflowStatusHelper;
    private final I18nTranslator i18nTranslator;
    private final NameResolver nameResolver;

    public CustomWorkflowSchemeServiceImpl(WorkflowBundle.Factory workflowBundleFactory, WorkflowImporterFactory workflowImporterFactory, WorkflowSchemeManager workflowSchemeManager, WorkflowManager workflowManager, WorkflowStatusHelper workflowStatusHelper, I18nTranslator i18nTranslator, NameResolver nameResolver) {
        this(new SharedWorkflowImportPlanFactoryHelper(), workflowBundleFactory, workflowImporterFactory, workflowSchemeManager, workflowManager, workflowStatusHelper, i18nTranslator, nameResolver);
    }

    @VisibleForTesting
    CustomWorkflowSchemeServiceImpl(SharedWorkflowImportPlanFactoryHelper sharedWorkflowImportPlanFactoryHelper, WorkflowBundle.Factory workflowBundleFactory, WorkflowImporterFactory workflowImporterFactory, WorkflowSchemeManager workflowSchemeManager, WorkflowManager workflowManager, WorkflowStatusHelper workflowStatusHelper, I18nTranslator i18nTranslator, NameResolver nameResolver) {
        this.sharedWorkflowImportPlanFactoryHelper = sharedWorkflowImportPlanFactoryHelper;
        this.workflowBundleFactory = workflowBundleFactory;
        this.workflowImporterFactory = workflowImporterFactory;
        this.workflowSchemeManager = workflowSchemeManager;
        this.workflowManager = workflowManager;
        this.workflowStatusHelper = workflowStatusHelper;
        this.i18nTranslator = i18nTranslator;
        this.nameResolver = nameResolver;
    }

    @Override
    public WorkflowSchemeCreationResult configureCustomWorkflowSchemeForProjectFromTemplate(Project project, ConfigTemplate configTemplate, Map<String, IssueType> issueTypeMap) {
        if (!configTemplate.workflowSchemeTemplate().isPresent()) {
            return new WorkflowSchemeCreationResult();
        }
        HashMap createdWorkflowMap = Maps.newHashMap();
        for (WorkflowTemplate workflowTemplate : ((WorkflowSchemeTemplate)configTemplate.workflowSchemeTemplate().get()).workflowTemplates()) {
            JiraWorkflow workflow = this.importWorkflow(project.getKey(), workflowTemplate);
            if (workflow == null) {
                return new WorkflowSchemeCreationResult();
            }
            createdWorkflowMap.put(workflowTemplate.key(), workflow);
        }
        Scheme workflowScheme = this.createWorkflowScheme(configTemplate, issueTypeMap, createdWorkflowMap, project.getKey());
        if (workflowScheme == null) {
            return new WorkflowSchemeCreationResult();
        }
        this.workflowSchemeManager.addSchemeToProject(project, workflowScheme);
        return new WorkflowSchemeCreationResult(workflowScheme, createdWorkflowMap);
    }

    private Scheme createWorkflowScheme(ConfigTemplate configTemplate, Map<String, IssueType> issueTypeMap, Map<String, JiraWorkflow> createdWorkflowMap, String projectKey) {
        WorkflowSchemeTemplate workflowSchemeTemplate = (WorkflowSchemeTemplate)configTemplate.workflowSchemeTemplate().get();
        String workflowSchemeName = this.nameResolver.getUniqueName(projectKey, workflowSchemeTemplate.name(), new IsWorkflowSchemeNameUnique());
        Scheme workflowSchemeObject = this.workflowSchemeManager.createSchemeObject(workflowSchemeName, this.i18nTranslator.getSystemTranslation(workflowSchemeTemplate.description()));
        try {
            GenericValue workflowSchemeGV = this.workflowSchemeManager.getScheme(workflowSchemeObject.getId());
            if (configTemplate.issueTypeSchemeTemplate().isPresent()) {
                Preconditions.checkNotNull(issueTypeMap);
                for (IssueTypeTemplate issueTypeTemplate : ((IssueTypeSchemeTemplate)configTemplate.issueTypeSchemeTemplate().get()).issueTypeTemplates()) {
                    if (!issueTypeTemplate.workflow().isPresent()) continue;
                    JiraWorkflow workflow = createdWorkflowMap.get(issueTypeTemplate.workflow().get());
                    this.workflowSchemeManager.addWorkflowToScheme(workflowSchemeGV, workflow.getName(), issueTypeMap.get(issueTypeTemplate.key()).getId());
                }
            }
            if (workflowSchemeTemplate.defaultWorkflow().isPresent()) {
                JiraWorkflow defaultWorkflow = createdWorkflowMap.get(workflowSchemeTemplate.defaultWorkflow().get());
                this.workflowSchemeManager.addWorkflowToScheme(workflowSchemeGV, defaultWorkflow.getName(), "0");
            }
        }
        catch (GenericEntityException e) {
            LOG.error("Error while creating Workflow Scheme: {}", (Object)e.getMessage());
            return null;
        }
        return workflowSchemeObject;
    }

    private JiraWorkflow importWorkflow(String projectKey, WorkflowTemplate workflowTemplate) {
        WorkflowBundle workflowBundle = this.importWorkflowBundle(workflowTemplate);
        if (workflowBundle == null) {
            return null;
        }
        SharedWorkflowImportPlan sharedWorkflowImportPlan = this.sharedWorkflowImportPlanFactoryHelper.getSharedWorkflowImportPlan(workflowBundle);
        sharedWorkflowImportPlan.setStatusMappings(this.getStatusMappings(workflowBundle.getWorkflowXml(), sharedWorkflowImportPlan.getStatusInfo()));
        sharedWorkflowImportPlan.setWorkflowName(this.nameResolver.getUniqueName(projectKey, workflowTemplate.name(), new IsWorkflowNameUnique()));
        JiraWorkflowSharingImporter jiraWorkflowSharingImporter = this.workflowImporterFactory.newImporter();
        return jiraWorkflowSharingImporter.importWorkflow(sharedWorkflowImportPlan);
    }

    private List<StatusMapping> getStatusMappings(String workflowXml, List<StatusInfo> statusInfo) {
        Map holders = this.workflowStatusHelper.getStatusHolders(workflowXml, statusInfo);
        return new ArrayList<StatusMapping>(holders.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkflowBundle importWorkflowBundle(WorkflowTemplate workflowTemplate) {
        InputStream wbInputStream = null;
        WorkflowBundle workflowBundle = null;
        try {
            wbInputStream = workflowTemplate.bundleUrl().openStream();
            workflowBundle = this.workflowBundleFactory.bundle(wbInputStream, WorkflowBundle.BundleSource.MANUAL);
        }
        catch (IOException e) {
            LOG.error("Error while parsing Workflow {}: {}", (Object)workflowTemplate.name(), (Object)e.getMessage());
        }
        catch (ValidationException e) {
            LOG.error("Error while validating Workflow {}: {}", (Object)workflowTemplate.name(), (Object)e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)wbInputStream);
        }
        return workflowBundle;
    }

    private class IsWorkflowNameUnique
    implements Predicate<String> {
        private IsWorkflowNameUnique() {
        }

        public boolean apply(String name) {
            return CustomWorkflowSchemeServiceImpl.this.workflowManager.getWorkflow(name) == null;
        }
    }

    private class IsWorkflowSchemeNameUnique
    implements Predicate<String> {
        private IsWorkflowSchemeNameUnique() {
        }

        public boolean apply(String name) {
            return CustomWorkflowSchemeServiceImpl.this.workflowSchemeManager.getWorkflowSchemeObj(name) == null;
        }
    }

    static class SharedWorkflowImportPlanFactoryHelper {
        SharedWorkflowImportPlanFactoryHelper() {
        }

        public SharedWorkflowImportPlan getSharedWorkflowImportPlan(WorkflowBundle workflowBundle) {
            return new SharedWorkflowImportPlan(ComponentAccessor.getPluginAccessor(), workflowBundle);
        }
    }
}

