/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.rest;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.template.DemoProjectManager;
import com.atlassian.jira.project.template.module.DemoProjectModule;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.projecttemplates.model.ApplyTemplateParam;
import com.atlassian.jira.projecttemplates.model.ProjectCreationResult;
import com.atlassian.jira.projecttemplates.model.ProjectTemplateDialogData;
import com.atlassian.jira.projecttemplates.model.ProjectTypeToTemplates;
import com.atlassian.jira.projecttemplates.rest.DemoProjectBean;
import com.atlassian.jira.projecttemplates.service.ProjectTemplateService;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ValidationFailureException;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="templates")
public class ProjectTemplatesResource {
    private final DemoProjectManager demoProjectManager;
    private final ProjectTemplateService projectTemplateService;
    private final ProjectService projectService;
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext authContext;
    private final JiraLicenseService licenseService;
    private final AvatarService avatarService;
    private final UserSearchService userSearchService;

    public ProjectTemplatesResource(ProjectTemplateService projectTemplateService, ProjectService projectService, ProjectManager projectManager, JiraAuthenticationContext authContext, JiraLicenseService licenseService, AvatarService avatarService, DemoProjectManager demoProjectManager, UserSearchService userSearchService) {
        this.projectTemplateService = projectTemplateService;
        this.projectService = projectService;
        this.projectManager = projectManager;
        this.authContext = authContext;
        this.licenseService = licenseService;
        this.avatarService = avatarService;
        this.demoProjectManager = demoProjectManager;
        this.userSearchService = userSearchService;
    }

    private UserSearchParams twoUserLimitSearchParams() {
        return UserSearchParams.builder().allowEmptyQuery(true).includeActive(true).includeInactive(true).maxResults(Integer.valueOf(2)).sorted(false).build();
    }

    private boolean hasMoreThanOneUserInSystem() {
        int foundCount = this.userSearchService.findUserNames("", this.twoUserLimitSearchParams()).size();
        return foundCount > 1;
    }

    private boolean hasExactlyOneUserInSystem() {
        int foundCount = this.userSearchService.findUserNames("", this.twoUserLimitSearchParams()).size();
        return foundCount == 1;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getProjectTemplates() {
        ProjectTemplateDialogData data = this.getResponseData(this.projectTemplateService.getProjectTemplatesGroupedByType(this.authContext.getLoggedInUser()));
        return Response.ok((Object)data).build();
    }

    private ProjectTemplateDialogData getResponseData(List<ProjectTypeToTemplates> groupedTemplates) {
        ProjectTemplateDialogData.Builder builder = new ProjectTemplateDialogData.Builder();
        builder.projectTemplatesGroupedByType(groupedTemplates);
        ApplicationUser defaultLead = this.getDefaultLead();
        return builder.maxKeyLength(this.projectService.getMaximumKeyLength()).minNameLength(2).maxNameLength(this.projectService.getMaximumNameLength()).shouldShowProjectLead(!this.authContext.isLoggedInUser() || this.hasMoreThanOneUserInSystem()).serverId(this.licenseService.getServerId()).currentUserName(defaultLead.getUsername()).currentUserDisplayName(defaultLead.getDisplayName()).currentUserAvatarUrl(this.getDefaultLeadAvatarUrl()).projectCount(this.getProjectCount()).build();
    }

    private List<ProjectTypeToTemplates> getDemoProjectsGroupedByType() {
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        List demoProjects = this.demoProjectManager.getDemoProjects();
        Map<String, List<DemoProjectModule>> groupedProjects = demoProjects.stream().filter(module -> module.getProjectTypeKey().isPresent()).collect(Collectors.groupingBy(module -> (String)module.getProjectTypeKey().get()));
        return (List)this.projectTemplateService.getAccessibleProjectTypes().stream().filter(projectType -> groupedProjects.containsKey(projectType.getKey().getKey())).map(projectType -> new ProjectTypeToTemplates((ProjectType)projectType, (List)((List)groupedProjects.get(projectType.getKey().getKey())).stream().map(module -> DemoProjectBean.fromModule(this.authContext.getI18nHelper(), module)).collect(CollectorsUtil.toImmutableList()), this.projectTemplateService.generateApplicationInfoForProjectKey(projectType.getKey(), loggedInUser))).collect(CollectorsUtil.toImmutableList());
    }

    @GET
    @Path(value="demo-projects")
    @Produces(value={"application/json"})
    public Response getDemoProjectTemplates() {
        ProjectTemplateDialogData data = this.getResponseData(this.getDemoProjectsGroupedByType());
        return Response.ok((Object)data).build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    public Response createProjectFromFormRequest(@FormParam(value="name") String name, @FormParam(value="key") String key, @FormParam(value="lead") String leadName, @FormParam(value="licenseUser") boolean licenseUser, @FormParam(value="projectTemplateWebItemKey") String projectTemplateWebItemKey, @Context HttpServletRequest request) {
        Map requestParams = request.getParameterMap();
        if (this.hasExactlyOneUserInSystem()) {
            leadName = this.getDefaultLead().getUsername();
        }
        ApplicationUser currentUser = this.authContext.getUser();
        ApplyTemplateParam applyTemplateParam = ApplyTemplateParam.create().setCurrentUser(currentUser).setProjectName(name).setProjectKey(key.toUpperCase()).setProjectDescription(this.getDescription()).setLeadName(leadName).setUrl(this.getUrl()).setProjectTemplateWebItemKey(projectTemplateWebItemKey).setTemplateConfigurationParams(requestParams);
        applyTemplateParam = applyTemplateParam.setAddUserToLicense(licenseUser);
        try {
            ProjectCreationResult result = this.projectTemplateService.applyProjectTemplate(applyTemplateParam);
            return Response.ok((Object)result).build();
        }
        catch (ValidationFailureException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)e.errors())).build();
        }
    }

    private String getDescription() {
        return "";
    }

    private String getUrl() {
        return "";
    }

    private ApplicationUser getDefaultLead() {
        ApplicationUser user = this.authContext.getLoggedInUser();
        return user != null ? user : null;
    }

    private String getDefaultLeadAvatarUrl() {
        return this.avatarService.getAvatarURL(this.authContext.getLoggedInUser(), this.authContext.getLoggedInUser(), Avatar.Size.SMALL).toString();
    }

    private long getProjectCount() {
        return this.projectManager.getProjectCount();
    }
}

