/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.rest;

import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.fields.rest.ProjectSuggestionProvider;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projecttemplates.model.ProjectCreationResultFactory;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.project.ProjectInputBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="createshared")
public class CreateSharedProjectResource {
    private final ProjectSuggestionProvider projectSuggestionProvider;
    private final ProjectService projectService;
    private final JiraAuthenticationContext authenticationContext;
    private final UserManager userManager;
    private final ProjectCreationResultFactory resultFactory;

    public CreateSharedProjectResource(ProjectSuggestionProvider projectSuggestionProvider, ProjectService projectService, JiraAuthenticationContext authenticationContext, UserManager userManager, ProjectCreationResultFactory resultFactory) {
        this.projectSuggestionProvider = projectSuggestionProvider;
        this.projectService = projectService;
        this.authenticationContext = authenticationContext;
        this.userManager = userManager;
        this.resultFactory = resultFactory;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getProjectSuggestions() {
        List projectPickerSuggestions = this.projectSuggestionProvider.getProjectPickerSuggestions(ProjectPermissions.BROWSE_PROJECTS, Optional.empty(), true);
        return Response.ok((Object)projectPickerSuggestions).build();
    }

    @POST
    @Path(value="{existingProjectId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createSharedProject(@PathParam(value="existingProjectId") Long existingProjectId, ProjectInputBean input) {
        ProjectCreationData data;
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        ProjectService.CreateProjectValidationResult validationResult = this.projectService.validateCreateProjectBasedOnExistingProject(user, existingProjectId, data = new ProjectCreationData.Builder().withName(input.getName()).withKey(input.getKey()).withLead(this.userManager.getUserByName(input.getLead())).build());
        if (validationResult.isValid()) {
            Project newProject = this.projectService.createProject(validationResult);
            return Response.ok((Object)this.resultFactory.create(newProject)).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)validationResult.getErrorCollection())).build();
    }
}

