/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.model;

import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeKeyFormatter;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class ProjectTypeBean {
    private String projectTypeKey;
    private String projectTypeDisplayKey;
    private String icon;

    public ProjectTypeBean(ProjectType jiraProjectType) {
        this.projectTypeKey = jiraProjectType.getKey().getKey();
        this.projectTypeDisplayKey = ProjectTypeKeyFormatter.format((ProjectTypeKey)jiraProjectType.getKey());
        this.icon = jiraProjectType.getIcon();
    }

    @JsonProperty
    public String getProjectTypeKey() {
        return this.projectTypeKey;
    }

    @JsonProperty
    public String getProjectTypeDisplayKey() {
        return this.projectTypeDisplayKey;
    }

    @JsonProperty
    public String getIcon() {
        return this.icon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectTypeBean that = (ProjectTypeBean)o;
        if (!this.icon.equals(that.icon)) {
            return false;
        }
        if (!this.projectTypeDisplayKey.equals(that.projectTypeDisplayKey)) {
            return false;
        }
        return this.projectTypeKey.equals(that.projectTypeKey);
    }

    public int hashCode() {
        int result = this.projectTypeKey.hashCode();
        result = 31 * result + this.projectTypeDisplayKey.hashCode();
        result = 31 * result + this.icon.hashCode();
        return result;
    }
}

