/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.util.InstanceInfo;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class AnalyticsDataProvider
implements WebResourceDataProvider {
    private static final ObjectMapper OBJECT_MAPPER;
    private final String DATE_CACHE_KEY = "instanceCreatedDate";
    private final InstanceInfo instanceInfo;
    private final Cache<String, String> instanceCreatedDateCache;

    public AnalyticsDataProvider(CacheManager cacheManager, InstanceInfo instanceInfo) {
        this.instanceInfo = instanceInfo;
        this.instanceCreatedDateCache = cacheManager.getCache(AnalyticsDataProvider.class.getName() + ".instanceCreatedDateCache", (CacheLoader)new UserAttributesCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(1L, TimeUnit.DAYS).flushable().build());
    }

    public Jsonable get() {
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                ImmutableMap map = ImmutableMap.of((Object)"instanceCreatedDate", (Object)AnalyticsDataProvider.this.instanceCreatedDateCache.get((Object)"instanceCreatedDate"));
                OBJECT_MAPPER.writeValue(writer, (Object)map);
            }
        };
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        OBJECT_MAPPER = mapper;
    }

    private class UserAttributesCacheLoader
    implements CacheLoader<String, String> {
        private UserAttributesCacheLoader() {
        }

        @Nonnull
        public String load(@Nonnull String s) {
            return AnalyticsDataProvider.this.instanceInfo.getInstanceCreatedDate().map(date -> new SimpleDateFormat("yyyy-MM-dd").format((Date)date)).orElse("");
        }
    }
}

