(function() {
    JPT.TemplateInfoViewImpl = Backbone.View.extend({

        initialize: function(options) {
            _.bindAll(this, "draw", "onNext")
        },

        draw: function(templatePath, name) {
            var page = JPT.DialogController.addPage({
                name: "template-info",
                title: name,
                panelName: "template-info",
                backButton: true,
                submitButtonText: AJS.I18n.getText("add.project.select"),
                submitButtonCallback: this.onNext,
                submitButtonClass: "template-info-dialog-create-button"
            });

            var templateInfoPanel = this._nameToObj(templatePath)();
            JPT.DialogController.dialog.getPanel(page.id, 0).html(templateInfoPanel);

            JPT.DialogController.dialog.gotoPage(page.id);
        },

        _nameToObj: function(name) {
            return _.reduce(name.split('.'), function(obj, name) { if (obj) return obj[name]; }, window);
        },

        onNext: function(e) {
            JPT.TemplateInfoController.next();
            return false;
        }
    });

})();
