JPT.SelectProjectTemplateView = {};

JPT.SelectProjectTemplateView.ROW_LENGTH = 2;

JPT.SelectProjectTemplateView.draw = function draw(projectTemplates) {

    this.page = JPT.DialogController.addPage({
        name: "project-templates-page",
        title: AJS.I18n.getText("add.project.select.template.title"),
        panelName: "ProjectTemplatesListPanel",
        backButton: false,
        submitButtonText: AJS.I18n.getText("add.project.next"),
        submitButtonCallback: JPT.SelectProjectTemplateController.dialogSubmitted,
        submitButtonClass: "create-project-dialog-create-button"
    });

    JPT.DialogController.dialog.getPanel(this.page.id, 0).html(
        JIRA.Templates.ProjectTemplates.renderList({
            projectTemplates: projectTemplates
        })
    );

    if (JPT.ConfigModel.projectCount >= 2) {
        AJS.$(JIRA.Templates.ProjectTemplates.addWorkflowsLink({
                baseUrl : contextPath
            }))
            .appendTo(JPT.DialogController.$dialogElement.find(".dialog-title"));
    }

    var $nextButton = JPT.DialogController.$dialogElement.find(".create-project-dialog-create-button");
    JPT.DialogController.$dialogElement.find(".template").click(function() {
        var $this = AJS.$(this);
        $this.addClass("selected").siblings().removeClass("selected");
    }).dblclick(function(e) {
            $nextButton.click();
        }).focus(function () {
            AJS.$(this).click();
        });

    var $templatesContainer = JPT.SelectProjectTemplateView.get$TemplatesContainer();

    AJS.$(JIRA.Templates.ProjectTemplates.importProjectLink({
            baseUrl : contextPath
        }))
        .prependTo(JPT.DialogController.$dialogElement.find(".dialog-button-panel"));

    JPT.SelectProjectTemplateView.bindKeyboardEvents($templatesContainer);

    if (projectTemplates.length == 0) {
        $nextButton.attr("disabled", "disabled");
    }

    JPT.SelectProjectTemplateView.focusOnFirstTemplate($templatesContainer);
};

JPT.SelectProjectTemplateView.get$TemplatesContainer = function getTemplatesContainer() {
    return JPT.DialogController.$dialogElement.find('.templates');
};

JPT.SelectProjectTemplateView.focusOnFirstTemplate = function focusOnFirstTemplate($templatesContainer) {
    JPT.DialogController.$dialogElement.find(".template:first-child").click();
    // Make sure me don't loose the focus because of any other interactions
    setTimeout(function (){
        $templatesContainer.focus();
    }, 0);
};

JPT.SelectProjectTemplateView.getSelectedTemplateData = function getSelectedTemplateData() {
    var $selectedTemplate = JPT.DialogController.$dialogElement.find(".template.selected");

    return $selectedTemplate.data();
};

/**
 * Converts arrow directions into sibling movement amounts in a grid.
 * @param which - the code of the key pressed
 * @return {Number} the amount to move, or 0 if no move should occur for this key code
 */
JPT.SelectProjectTemplateView.getMoveDeltaForKey = function (which) {
    switch (which) {
        case 37: return -1; // left
        case 39: return +1; // right
        case 38: return -JPT.SelectProjectTemplateView.ROW_LENGTH; // up
        case 40: return +JPT.SelectProjectTemplateView.ROW_LENGTH; // down
    }
    return 0;
};

/**
 * Key-bindings on arrow-keys to change the selected template in the template container.
 */
JPT.SelectProjectTemplateView.bindKeyboardEvents = function ($container) {
    $container.bind("keydown", function (e) {
        var delta = JPT.SelectProjectTemplateView.getMoveDeltaForKey(e.which);
        if (delta) {
            JPT.SelectProjectTemplateView.moveSelection($container, delta);
            return AJS.stopEvent(e);
        }
    });
};

/**
 * Move the selection in the template container forward or backward by a specified number of templates
 * @param container the template container jQuery object
 * @param delta - positive to move forward, negative to move backward
 */
JPT.SelectProjectTemplateView.moveSelection = function (container, delta) {
    var $results = container.find('.template');
    var $selected = $results.filter('.selected');
    var index = $results.index($selected) + delta;
    if (index < $results.length && index >= 0) {
        var $next = $results.eq(index);
        $next.click().focus();

        JPT.SelectProjectTemplateView.scrollToSelectedElement($next);
    }
};

JPT.SelectProjectTemplateView.scrollToSelectedElement = function scrollToSelectedElement($selected) {
    var $itemContainer = AJS.$(".dialog-panel-body.pt-content");
    var itemContainerTopPosition = $itemContainer.offset().top;
    var nextTopPosition = $selected.offset().top;
    var nextBottomPosition = nextTopPosition + $selected.height();
    var itemContainerBottomPosition = itemContainerTopPosition + $itemContainer.height();

    if (nextTopPosition < itemContainerTopPosition) {
        $itemContainer.scrollTop($itemContainer.scrollTop() - (itemContainerTopPosition - nextTopPosition));
    } else if(nextBottomPosition > (itemContainerTopPosition + $itemContainer.height())) {
        $itemContainer.scrollTop($itemContainer.scrollTop() + nextBottomPosition - itemContainerBottomPosition);
    }
};

JPT.SelectProjectTemplateView.get$NextButton = function getNextButton() {
    return JPT.DialogController.$dialogElement.find(".create-project-dialog-create-button");
};

JPT.SelectProjectTemplateView.disableNextButton = function disableNextButton() {
    JPT.SelectProjectTemplateView.get$NextButton().attr('disabled','disabled');
};

JPT.SelectProjectTemplateView.truncateTemplateDescriptions = function truncateTemplateDescriptions() {
    var locale = AJS.Meta.get("user-locale");
    var wrap = "word";
    if (locale === "ja_JP") {
        wrap = "letter";
    }
    JPT.DialogController.$dialogElement.find(".template-description").each(function() {
        AJS.$(this).dotdotdot({
            'wrap': wrap,
            'lastCharacter': {
                'remove'		: [ ' ', ',', ';', '.', '!', '?', '。' ],
                'noEllipsis'	: []
            }
        });
    });
};
