AJS.$(function () {
    var confluenceProjectLink = localStorage.getItem(JPT.AddProjectController.localStoragePrefix + "confluenceProject");
    var fishEyeProjectLink = localStorage.getItem(JPT.AddProjectController.localStoragePrefix + "fisheyeProject");
    var crucibleProjectLink = localStorage.getItem(JPT.AddProjectController.localStoragePrefix + "crucibleProject");
    var bambooProjectLink = localStorage.getItem(JPT.AddProjectController.localStoragePrefix + "bambooProject");

    localStorage.removeItem(JPT.AddProjectController.localStoragePrefix + "confluenceProject");
    localStorage.removeItem(JPT.AddProjectController.localStoragePrefix + "fisheyeProject");
    localStorage.removeItem(JPT.AddProjectController.localStoragePrefix + "crucibleProject");
    localStorage.removeItem(JPT.AddProjectController.localStoragePrefix + "bambooProject");

    var message;
    function formatAnchor(link, label) {
        return JIRA.Templates.ProjectTemplates.formatAnchor({
            href: link,
            body: label,
            title: label
        });
    }
    function createProjectLinks(confluenceProjectLink, fecruProjectLink, crucibleProjectLink, bambooProjectLink) {
        var links = [];
        links.push(AJS.I18n.getText("remote.projects.created.summary.ondemand.jira.project"));
        if (confluenceProjectLink) {
            links.push(formatAnchor(confluenceProjectLink, AJS.I18n.getText("remote.projects.created.summary.ondemand.confluence.project")));
        }
        if (fecruProjectLink) {
            links.push(formatAnchor(fecruProjectLink, AJS.I18n.getText("remote.projects.created.summary.ondemand.fisheye.project")));
        }
        if (crucibleProjectLink) {
            links.push(formatAnchor(crucibleProjectLink, AJS.I18n.getText("remote.projects.created.summary.ondemand.crucible.project")));
        }
        if (bambooProjectLink) {
            links.push(formatAnchor(bambooProjectLink, AJS.I18n.getText("remote.projects.created.summary.ondemand.bamboo.project")));
        }
        return links;
    }
    function createMessage(confluenceProjectLink, fecruProjectLink, crucibleProjectLink, bambooProjectLink) {
        var title = AJS.I18n.getText("remote.projects.created.summary.ondemand.projects.created.title");
        var projectLinks = createProjectLinks(confluenceProjectLink, fecruProjectLink, crucibleProjectLink, bambooProjectLink);
        var lastLink = projectLinks.pop();
        return (projectLinks.length > 0) ? AJS.format(title, projectLinks.join(", "), lastLink) : null;
    }
    function scrollTo(selector) {
        var settingsOffset = AJS.$(selector).offset();
        if (settingsOffset) {
            window.scrollTo(settingsOffset.left, settingsOffset.top);
        }
    }

    if (confluenceProjectLink || fishEyeProjectLink || crucibleProjectLink || bambooProjectLink) {
        message = createMessage(confluenceProjectLink, fishEyeProjectLink, crucibleProjectLink, bambooProjectLink);
        if (message) {
            JIRA.Messages.showSuccessMsg(message, {
                closeable:true
            });
        }
        scrollTo("#project-config-webpanel-summary-settings");
    }
});