/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.jira.blueprint.template.IssueTypeSchemeTemplate;
import com.atlassian.jira.blueprint.template.IssueTypeTemplate;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.projecttemplates.model.IssueTypeSchemeCreationResult;
import com.atlassian.jira.projecttemplates.service.CustomIssueTypeSchemeService;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.ofbiz.GenericValueUtils;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomIssueTypeSchemeServiceImpl
implements CustomIssueTypeSchemeService {
    public static final String ISSUE_TYPE_NAME = "IssueType";
    private static final int MAX_NAME_LENGTH = 250;
    private final ConstantsManager constantsManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    protected final JiraContextTreeManager treeManager;
    private final FieldManager fieldManager;
    private final I18nResolver i18nResolver;
    private final ApplicationProperties applicationProperties;

    public CustomIssueTypeSchemeServiceImpl(ConstantsManager constantsManager, FieldConfigSchemeManager fieldConfigSchemeManager, FieldManager fieldManager, I18nResolver i18nResolver, ApplicationProperties applicationProperties, ProjectManager projectManager, IssueTypeSchemeManager issueTypeSchemeManager) {
        this.constantsManager = constantsManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.fieldManager = fieldManager;
        this.i18nResolver = i18nResolver;
        this.applicationProperties = applicationProperties;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.treeManager = new JiraContextTreeManager(projectManager, constantsManager);
    }

    @Override
    public IssueTypeSchemeCreationResult configureCustomIssueTypeSchemeForProjectFromTemplate(Project project, IssueTypeSchemeTemplate issueTypeSchemeTemplate) {
        if (issueTypeSchemeTemplate == null) {
            return new IssueTypeSchemeCreationResult();
        }
        Map<String, IssueType> issueTypeMap = this.getIssueTypesInstancesOfIssueTypeTemplateScheme(issueTypeSchemeTemplate);
        FieldConfigScheme issueTypeScheme = this.createIssueTypeScheme(issueTypeSchemeTemplate, issueTypeMap, project);
        return new IssueTypeSchemeCreationResult(issueTypeScheme, issueTypeMap);
    }

    private FieldConfigScheme createIssueTypeScheme(IssueTypeSchemeTemplate issueTypeSchemeTemplate, Map<String, IssueType> issueTypeMap, Project project) {
        String schemeName = this.getIssueTypeSchemeNameForProjectKey(project.getKey(), issueTypeSchemeTemplate.name());
        Long[] projectIds = GenericValueUtils.transformToLongIds(Collections.singletonList(project.getGenericValue()));
        FieldConfigScheme issueTypeScheme = this.issueTypeSchemeManager.create(schemeName, this.getSystemTranslationForValue(issueTypeSchemeTemplate.description()), this.getIssueTypeIds(issueTypeMap));
        List issueContexts = CustomFieldUtils.buildJiraIssueContexts((boolean)false, null, (Long[])projectIds, (JiraContextTreeManager)this.treeManager);
        issueTypeScheme = this.fieldConfigSchemeManager.updateFieldConfigScheme(issueTypeScheme, issueContexts, this.getIssueTypeField());
        return issueTypeScheme;
    }

    private ConfigurableField getIssueTypeField() {
        return this.fieldManager.getConfigurableField("issuetype");
    }

    private String getIssueTypeSchemeNameForProjectKey(String projectKey, String issueTypeSchemeName) {
        String proposedName = projectKey + ": " + this.getSystemTranslationForValue(issueTypeSchemeName);
        if (proposedName.length() > 250) {
            proposedName = proposedName.substring(0, 250);
        }
        return this.getUniqueIssueTypeSchemeName(proposedName);
    }

    private String getUniqueIssueTypeSchemeName(String proposedName) {
        String schemeName = proposedName;
        int counter = 1;
        while (!this.isIssueTypeSchemeNameUnique(schemeName)) {
            schemeName = proposedName + " (" + counter + ")";
            ++counter;
        }
        return schemeName;
    }

    private boolean isIssueTypeSchemeNameUnique(String name) {
        name = name.toUpperCase();
        for (FieldConfigScheme scheme : this.fieldConfigSchemeManager.getConfigSchemesForField(this.getIssueTypeField())) {
            if (!scheme.getName().toUpperCase().equals(name)) continue;
            return false;
        }
        return true;
    }

    private List<String> getIssueTypeIds(Map<String, IssueType> issueTypes) {
        ArrayList issueTypeIds = Lists.newArrayList();
        for (IssueType issueType : issueTypes.values()) {
            issueTypeIds.add(issueType.getId());
        }
        return issueTypeIds;
    }

    private Map<String, IssueType> getIssueTypesInstancesOfIssueTypeTemplateScheme(IssueTypeSchemeTemplate schemeTemplate) {
        HashMap issueTypes = Maps.newHashMap();
        for (IssueTypeTemplate template : schemeTemplate.issueTypeTemplates()) {
            issueTypes.put(template.key(), this.getIssueType(template));
        }
        return issueTypes;
    }

    private IssueType getIssueType(IssueTypeTemplate issueTypeTemplate) {
        IssueType issueType = (IssueType)this.constantsManager.getConstantByNameIgnoreCase(ISSUE_TYPE_NAME, issueTypeTemplate.name());
        if (issueType == null) {
            issueType = this.createIssueTypeFromTemplate(issueTypeTemplate);
        }
        return issueType;
    }

    private IssueType createIssueTypeFromTemplate(IssueTypeTemplate issueTypeTemplate) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        this.constantsManager.validateCreateIssueType(issueTypeTemplate.name(), issueTypeTemplate.style(), issueTypeTemplate.description(), issueTypeTemplate.icon(), (ErrorCollection)errorCollection, ISSUE_TYPE_NAME);
        if (errorCollection.hasAnyErrors()) {
            throw new IllegalArgumentException("Validation error for issue type " + issueTypeTemplate.name() + ": " + errorCollection.getErrors());
        }
        IssueType issueType = null;
        try {
            issueType = this.constantsManager.insertIssueType(issueTypeTemplate.name(), null, issueTypeTemplate.style(), issueTypeTemplate.description(), issueTypeTemplate.icon());
        }
        catch (CreateException ex) {
            throw new IllegalArgumentException("Exception while creating Issue Type " + issueTypeTemplate.name(), ex);
        }
        return issueType;
    }

    private String getSystemTranslationForValue(String name) {
        return this.i18nResolver.getText(this.applicationProperties.getDefaultLocale(), name);
    }
}

