/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.model;

import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.api.application.bamboo.BambooProjectEntityType;
import com.atlassian.applinks.api.application.confluence.ConfluenceSpaceEntityType;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleProjectEntityType;
import com.atlassian.applinks.api.application.fecru.FishEyeRepositoryEntityType;
import com.atlassian.jira.projecttemplates.model.RemoteProjectLinks;

public class RemoteProjectLinksBuilder {
    private String confluenceProject;
    private String fisheyeProject;
    private String crucibleProject;
    private String bambooProject;

    public RemoteProjectLinksBuilder addEntityLink(EntityLink entityLink) {
        EntityType entityType = entityLink.getType();
        String url = entityLink.getDisplayUrl().toString();
        if (entityType instanceof ConfluenceSpaceEntityType) {
            this.confluenceProject = url;
        } else if (entityType instanceof FishEyeRepositoryEntityType) {
            this.fisheyeProject = url;
        } else if (entityType instanceof FishEyeCrucibleProjectEntityType) {
            this.crucibleProject = url;
        } else if (entityType instanceof BambooProjectEntityType) {
            this.bambooProject = url;
        }
        return this;
    }

    public RemoteProjectLinks build() {
        return new RemoteProjectLinks(this.confluenceProject, this.fisheyeProject, this.crucibleProject, this.bambooProject);
    }
}

