/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.model;

import com.atlassian.jira.user.ApplicationUser;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ApplyTemplateParam {
    private final ApplicationUser currentUser;
    private final String projectName;
    private final String projectKey;
    private final String projectDescription;
    private final String leadName;
    private final String url;
    private final Long assigneeType;
    private final String projectTemplateWebItemKey;
    private final Map<String, String[]> templateConfigurationParams;

    public static ApplyTemplateParam create() {
        return new ApplyTemplateParam();
    }

    private ApplyTemplateParam() {
        this(null, null, null, null, null, null, null, null, null);
    }

    private ApplyTemplateParam(ApplicationUser currentUser, String projectName, String projectKey, String projectDescription, String leadName, String url, Long assigneeType, String projectTemplateWebItemKey, Map<String, String[]> templateConfigurationParams) {
        this.currentUser = currentUser;
        this.projectName = projectName;
        this.projectKey = projectKey;
        this.projectDescription = projectDescription;
        this.leadName = leadName;
        this.url = url;
        this.assigneeType = assigneeType;
        this.projectTemplateWebItemKey = projectTemplateWebItemKey;
        this.templateConfigurationParams = templateConfigurationParams;
    }

    public ApplyTemplateParam setCurrentUser(ApplicationUser currentUser) {
        return new ApplyTemplateParam(currentUser, this.projectName, this.projectKey, this.projectDescription, this.leadName, this.url, this.assigneeType, this.projectTemplateWebItemKey, this.templateConfigurationParams);
    }

    public ApplicationUser getCurrentUser() {
        return this.currentUser;
    }

    public ApplyTemplateParam setAssigneeType(Long assigneeType) {
        return new ApplyTemplateParam(this.currentUser, this.projectName, this.projectKey, this.projectDescription, this.leadName, this.url, assigneeType, this.projectTemplateWebItemKey, this.templateConfigurationParams);
    }

    public Long getAssigneeType() {
        return this.assigneeType;
    }

    public ApplyTemplateParam setLeadName(String leadName) {
        return new ApplyTemplateParam(this.currentUser, this.projectName, this.projectKey, this.projectDescription, leadName, this.url, this.assigneeType, this.projectTemplateWebItemKey, this.templateConfigurationParams);
    }

    public String getLeadName() {
        return this.leadName;
    }

    public ApplyTemplateParam setProjectDescription(String projectDescription) {
        return new ApplyTemplateParam(this.currentUser, this.projectName, this.projectKey, projectDescription, this.leadName, this.url, this.assigneeType, this.projectTemplateWebItemKey, this.templateConfigurationParams);
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public ApplyTemplateParam setProjectKey(String projectKey) {
        return new ApplyTemplateParam(this.currentUser, this.projectName, projectKey, this.projectDescription, this.leadName, this.url, this.assigneeType, this.projectTemplateWebItemKey, this.templateConfigurationParams);
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public ApplyTemplateParam setProjectName(String projectName) {
        return new ApplyTemplateParam(this.currentUser, projectName, this.projectKey, this.projectDescription, this.leadName, this.url, this.assigneeType, this.projectTemplateWebItemKey, this.templateConfigurationParams);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public ApplyTemplateParam setProjectTemplateModuleKey(String projectTemplateModuleKey) {
        return new ApplyTemplateParam(this.currentUser, this.projectName, this.projectKey, this.projectDescription, this.leadName, this.url, this.assigneeType, this.projectTemplateWebItemKey, this.templateConfigurationParams);
    }

    public String getProjectTemplateModuleKey() {
        if (this.getTemplateConfigurationParams().containsKey("projectTemplateModuleKey")) {
            return this.getTemplateConfigurationParams().get("projectTemplateModuleKey")[0];
        }
        return this.getProjectTemplateWebItemKey();
    }

    public ApplyTemplateParam setProjectTemplateWebItemKey(String projectTemplateWebItemKey) {
        return new ApplyTemplateParam(this.currentUser, this.projectName, this.projectKey, this.projectDescription, this.leadName, this.url, this.assigneeType, projectTemplateWebItemKey, this.templateConfigurationParams);
    }

    public String getProjectTemplateWebItemKey() {
        return this.projectTemplateWebItemKey;
    }

    public ApplyTemplateParam setTemplateConfigurationParams(Map<String, String[]> templateConfigurationParams) {
        return new ApplyTemplateParam(this.currentUser, this.projectName, this.projectKey, this.projectDescription, this.leadName, this.url, this.assigneeType, this.projectTemplateWebItemKey, templateConfigurationParams);
    }

    public Map<String, String[]> getTemplateConfigurationParams() {
        return this.templateConfigurationParams;
    }

    public ApplyTemplateParam setUrl(String url) {
        return new ApplyTemplateParam(this.currentUser, this.projectName, this.projectKey, this.projectDescription, this.leadName, url, this.assigneeType, this.projectTemplateWebItemKey, this.templateConfigurationParams);
    }

    public String getUrl() {
        return this.url;
    }
}

