/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.blueprint.template;

import com.atlassian.jira.blueprint.template.WorkflowTemplate;
import com.atlassian.plugin.Plugin;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.net.URL;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JacksonInject;

public class WorkflowTemplateImpl
implements WorkflowTemplate {
    private final String key;
    private final String name;
    private final String bundlePath;
    private final URL bundleUrl;

    public WorkflowTemplateImpl(@JsonProperty(value="key") String key, @JsonProperty(value="name") String name, @JsonProperty(value="workflow-bundle") String bundlePath, @JacksonInject(value="plugin") Plugin plugin) {
        this.key = ((String)Preconditions.checkNotNull((Object)key)).toUpperCase();
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.bundlePath = (String)Preconditions.checkNotNull((Object)bundlePath);
        this.bundleUrl = this.getBundleURL(plugin);
    }

    @VisibleForTesting
    public WorkflowTemplateImpl(String key, String name, String bundlePath, URL bundleUrl) {
        this.key = key;
        this.name = name;
        this.bundlePath = bundlePath;
        this.bundleUrl = bundleUrl;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String bundlePath() {
        return this.bundlePath;
    }

    @Override
    public URL bundleUrl() {
        return this.bundleUrl;
    }

    public URL getBundleURL(Plugin plugin) {
        URL url = plugin.getClassLoader().getResource(this.bundlePath());
        if (url == null) {
            throw new IllegalArgumentException("Workflow bundle for workflow '" + this.name + "'not found on path specified: " + this.bundlePath);
        }
        return url;
    }
}

