/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.blueprint.module;

import com.atlassian.jira.blueprint.api.AddProjectHook;
import com.atlassian.jira.blueprint.descriptor.ProjectBlueprintModuleDescriptor;
import com.atlassian.jira.blueprint.module.AddProjectModule;
import com.atlassian.jira.blueprint.template.ConfigTemplate;
import com.atlassian.jira.blueprint.template.ConfigTemplateImpl;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.InjectableValues;
import org.codehaus.jackson.map.ObjectMapper;

public class BlueprintAddProjectModule
implements AddProjectModule {
    private final String addProjectHookClass;
    private final ModuleFactory moduleFactory;
    private final ProjectBlueprintModuleDescriptor moduleDescriptor;
    private final ConfigTemplate configTemplate;

    public BlueprintAddProjectModule(ModuleFactory moduleFactory, ProjectBlueprintModuleDescriptor moduleDescriptor, String addProjectHookClass, URL templateConfigurationFileUrl) {
        this.moduleFactory = moduleFactory;
        this.moduleDescriptor = moduleDescriptor;
        this.addProjectHookClass = addProjectHookClass;
        this.configTemplate = templateConfigurationFileUrl == null ? null : TemplateConfigFileParser.parse(templateConfigurationFileUrl, moduleDescriptor);
    }

    @Override
    public boolean hasConfigTemplate() {
        return this.configTemplate() != null;
    }

    @Override
    public ConfigTemplate configTemplate() {
        return this.configTemplate;
    }

    @Override
    public boolean hasProjectCreateHook() {
        return !StringUtils.isBlank((String)this.addProjectHookClass);
    }

    @Override
    public AddProjectHook addProjectHook() {
        if (Strings.isNullOrEmpty((String)this.addProjectHookClass)) {
            return null;
        }
        Object module = this.moduleFactory.createModule(this.addProjectHookClass, (ModuleDescriptor)this.moduleDescriptor);
        try {
            AddProjectHook addProjectHook = (AddProjectHook)module;
            return addProjectHook;
        }
        catch (ClassCastException ex) {
            throw new PluginException("The class '" + this.addProjectHookClass + "' is not an instance of AddProjectHook.", (Throwable)ex);
        }
    }

    private static class TemplateConfigFileParser {
        private TemplateConfigFileParser() {
        }

        public static ConfigTemplate parse(URL fileURL, ProjectBlueprintModuleDescriptor blueprintModuleDescriptor) {
            ConfigTemplate configTemplate = TemplateConfigFileParser.readFile(fileURL, blueprintModuleDescriptor);
            return configTemplate;
        }

        private static ConfigTemplate readFile(URL fileUrl, ProjectBlueprintModuleDescriptor blueprintModuleDescriptor) {
            InputStream inputStream = null;
            try {
                ConfigTemplate configTemplate;
                inputStream = fileUrl.openStream();
                ConfigTemplate configTemplate2 = configTemplate = TemplateConfigFileParser.parseInput(inputStream, blueprintModuleDescriptor);
                return configTemplate2;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error while reading file: " + fileUrl, e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }

        private static ConfigTemplate parseInput(InputStream inputStream, ProjectBlueprintModuleDescriptor moduleDescriptor) {
            ObjectMapper mapper = new ObjectMapper();
            InjectableValues.Std inject = new InjectableValues.Std().addValue("plugin", (Object)moduleDescriptor.getPlugin()).addValue("moduleDescriptor", (Object)moduleDescriptor);
            try {
                return (ConfigTemplate)mapper.reader(ConfigTemplateImpl.class).withInjectableValues((InjectableValues)inject).readValue(inputStream);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error while parsing configuration file.", e);
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("Invalid configuration file.", e);
            }
        }
    }
}

