/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.blueprint.api;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import java.util.Collections;
import java.util.Map;

@PublicApi
public final class ConfigureData {
    private final Project project;
    private final Scheme workflowScheme;
    private final Map<String, JiraWorkflow> createdWorkflows;
    private final FieldConfigScheme issueTypeScheme;
    private final Map<String, IssueType> createdIssueTypes;

    public static ConfigureData create(Project project, Scheme workflowScheme, Map<String, JiraWorkflow> createdWorkflows, FieldConfigScheme issueTypeScheme, Map<String, IssueType> createdIssueTypes) {
        return new ConfigureData(project, workflowScheme, createdWorkflows, issueTypeScheme, createdIssueTypes);
    }

    ConfigureData(Project project, Scheme workflowScheme, Map<String, JiraWorkflow> createdWorkflows, FieldConfigScheme issueTypeScheme, Map<String, IssueType> createdIssueTypes) {
        this.project = project;
        this.workflowScheme = workflowScheme;
        this.createdWorkflows = createdWorkflows;
        this.issueTypeScheme = issueTypeScheme;
        this.createdIssueTypes = createdIssueTypes;
    }

    public Project project() {
        return this.project;
    }

    public Scheme workflowScheme() {
        return this.workflowScheme;
    }

    public Map<String, JiraWorkflow> createdWorkflows() {
        return Collections.unmodifiableMap(this.createdWorkflows);
    }

    public FieldConfigScheme issueTypeScheme() {
        return this.issueTypeScheme;
    }

    public Map<String, IssueType> createdIssueTypes() {
        return Collections.unmodifiableMap(this.createdIssueTypes);
    }
}

