AJS.test.require(['com.atlassian.jira.plugins.jira-optimizer-plugin:jira-optimizer-plugin-resources'], function () {

    var RecommendationView = require('jira/optimizer-plugin/recommendationView');
    var contextPath = require('wrm/context-path');
    var Backbone = require('jira-optimizer-plugin/backbone-1.1.2');
    var $ = require('jquery');

    var mockedUrl = contextPath() + '/rest/optimizer/1/recommendation/';

    $('#qunit-fixture').append('<main id="main"><div id="jgp-header"></div><table><tbody><tr></tr></tbody></table></main>');

    module("initialization", {
        setup: function setup() {
            var _this = this;

            this.sandbox = sinon.sandbox.create();
            this.server = sinon.fakeServer.create();

            // copied fr... inspired by GH.Test.respondWith in Jira Agile
            this.respondWith = function (url, data, method, httpStatus) {
                _this.server.respondWith(method, new RegExp("^" + url + "(.*)"), [httpStatus, { "Content-Type": "application/json" }, JSON.stringify(data)]);
            };

            this.getErrorMessages = function () {
                return $('#aui-flag-container .aui-flag:visible .aui-message.aui-message-error.closeable');
            };
            this.closeErrorMessages = function () {
                return _this.getErrorMessages().find('.aui-close-button').click();
            };

            this.recommendationView = new RecommendationView({
                el: $('#qunit-fixture table tbody tr:first'),
                model: new (Backbone.Model.extend({
                    resolved: false,
                    url: function url() {
                        return mockedUrl;
                    }
                }))({ category: 'optimizer-unit-test', projectIds: ['001', '002'] })
            });
            this.recommendationView.render();
        },
        teardown: function teardown() {
            this.closeErrorMessages();
            this.recommendationView.destroy();
            this.server.restore();
            this.sandbox.restore();
        }
    });

    test("Should display an error flag when applying recommendation fails", function (assert) {
        assert.notOk(this.recommendationView.ui.actionButton.hasClass('hidden'), "Should not hide actionButton initially");
        assert.ok(this.recommendationView.ui.viewChangeButton.hasClass('hidden'), "Should not have viewChangeButton initially");
        assert.equal(this.getErrorMessages().length, 0, 'No flags are visible initially');

        this.respondWith(mockedUrl, {}, "PUT", 400);

        this.recommendationView.handleChangeContext();
        this.recommendationView.performAutomaticResolution();

        this.server.respond();
        assert.notOk(this.recommendationView.ui.actionButton.hasClass('hidden'), 'Should not hide actionButton if action fails');
        assert.ok(this.recommendationView.ui.viewChangeButton.hasClass('hidden'), 'Should not show viewChangeButton if action fails');
        assert.equal(this.getErrorMessages().length, 1, 'Should displayed an error flag if action fails');
    });
});