/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.action.ActionListener;
import org.springframework.statemachine.action.CompositeActionListener;
import org.springframework.statemachine.region.Region;
import org.springframework.statemachine.state.CompositeStateListener;
import org.springframework.statemachine.state.PseudoState;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.state.StateListener;
import org.springframework.statemachine.support.LifecycleObjectSupport;
import org.springframework.statemachine.trigger.Trigger;

public abstract class AbstractState<S, E>
extends LifecycleObjectSupport
implements State<S, E> {
    private static final Log log = LogFactory.getLog(AbstractState.class);
    private final S id;
    private final PseudoState<S, E> pseudoState;
    private final Collection<E> deferred;
    private final Collection<? extends Action<S, E>> entryActions;
    private final Collection<? extends Action<S, E>> exitActions;
    private final Collection<? extends Action<S, E>> stateActions;
    private final Collection<Region<S, E>> regions = new ArrayList<Region<S, E>>();
    private final StateMachine<S, E> submachine;
    private List<Trigger<S, E>> triggers = new ArrayList<Trigger<S, E>>();
    private final CompositeStateListener<S, E> stateListener = new CompositeStateListener();
    private final List<ScheduledFuture<?>> cancellableActions = new ArrayList();
    private CompositeActionListener<S, E> actionListener;

    public AbstractState(S id, PseudoState<S, E> pseudoState) {
        this(id, null, null, null, pseudoState);
    }

    public AbstractState(S id, Collection<E> deferred) {
        this(id, deferred, null, null);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions) {
        this(id, deferred, entryActions, exitActions, null);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, PseudoState<S, E> pseudoState) {
        this(id, deferred, entryActions, exitActions, pseudoState, null, null);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, PseudoState<S, E> pseudoState, StateMachine<S, E> submachine) {
        this(id, deferred, entryActions, exitActions, pseudoState, null, submachine);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, PseudoState<S, E> pseudoState, Collection<Region<S, E>> regions) {
        this(id, deferred, entryActions, exitActions, pseudoState, regions, null);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, PseudoState<S, E> pseudoState, Collection<Region<S, E>> regions, StateMachine<S, E> submachine) {
        this(id, deferred, entryActions, exitActions, null, pseudoState, regions, submachine);
    }

    public AbstractState(S id, Collection<E> deferred, Collection<? extends Action<S, E>> entryActions, Collection<? extends Action<S, E>> exitActions, Collection<? extends Action<S, E>> stateActions, PseudoState<S, E> pseudoState, Collection<Region<S, E>> regions, StateMachine<S, E> submachine) {
        this.id = id;
        this.deferred = deferred != null ? deferred : Collections.emptySet();
        this.entryActions = entryActions != null ? entryActions : Collections.emptySet();
        this.exitActions = exitActions != null ? exitActions : Collections.emptySet();
        this.stateActions = stateActions != null ? stateActions : Collections.emptySet();
        this.pseudoState = pseudoState;
        if (regions != null) {
            this.regions.addAll(regions);
        }
        this.submachine = submachine;
    }

    @Override
    public boolean sendEvent(Message<E> event) {
        return false;
    }

    @Override
    public boolean shouldDefer(Message<E> event) {
        return this.deferred.contains(event.getPayload());
    }

    @Override
    public void exit(StateContext<S, E> context) {
        this.cancelStateActions();
        this.stateListener.onExit(context);
        this.disarmTriggers();
    }

    @Override
    public void entry(StateContext<S, E> context) {
        this.stateListener.onEntry(context);
        this.armTriggers();
        this.scheduleStateActions(context);
    }

    @Override
    public S getId() {
        return this.id;
    }

    @Override
    public abstract Collection<S> getIds();

    @Override
    public abstract Collection<State<S, E>> getStates();

    @Override
    public PseudoState<S, E> getPseudoState() {
        return this.pseudoState;
    }

    @Override
    public Collection<E> getDeferredEvents() {
        return this.deferred;
    }

    @Override
    public Collection<? extends Action<S, E>> getEntryActions() {
        return this.entryActions;
    }

    @Override
    public Collection<? extends Action<S, E>> getExitActions() {
        return this.exitActions;
    }

    @Override
    public boolean isComposite() {
        return !this.regions.isEmpty();
    }

    @Override
    public boolean isOrthogonal() {
        return this.regions.size() > 1;
    }

    @Override
    public boolean isSimple() {
        return !this.isSubmachineState() && !this.isComposite();
    }

    @Override
    public boolean isSubmachineState() {
        return this.submachine != null;
    }

    @Override
    public void addStateListener(StateListener<S, E> listener) {
        this.stateListener.register(listener);
    }

    @Override
    public void removeStateListener(StateListener<S, E> listener) {
        this.stateListener.unregister(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActionListener(ActionListener<S, E> listener) {
        AbstractState abstractState = this;
        synchronized (abstractState) {
            if (this.actionListener == null) {
                this.actionListener = new CompositeActionListener();
            }
            this.actionListener.register(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActionListener(ActionListener<S, E> listener) {
        AbstractState abstractState = this;
        synchronized (abstractState) {
            if (this.actionListener != null) {
                this.actionListener.unregister(listener);
            }
        }
    }

    @Override
    protected void doStart() {
        this.armTriggers();
    }

    @Override
    protected void doStop() {
        this.disarmTriggers();
    }

    public StateMachine<S, E> getSubmachine() {
        return this.submachine;
    }

    public Collection<Region<S, E>> getRegions() {
        return this.regions;
    }

    public void setTriggers(List<Trigger<S, E>> triggers) {
        if (triggers != null) {
            this.triggers = triggers;
        } else {
            this.triggers.clear();
        }
    }

    public List<Trigger<S, E>> getTriggers() {
        return this.triggers;
    }

    protected void armTriggers() {
        for (Trigger<S, E> trigger : this.triggers) {
            trigger.arm();
        }
    }

    protected void disarmTriggers() {
        for (Trigger<S, E> trigger : this.triggers) {
            trigger.disarm();
        }
    }

    protected void cancelStateActions() {
        for (ScheduledFuture<?> future : this.cancellableActions) {
            future.cancel(true);
        }
        this.cancellableActions.clear();
    }

    protected void scheduleStateActions(StateContext<S, E> context) {
        for (Action<S, E> action : this.stateActions) {
            ScheduledFuture<?> future = this.scheduleAction(action, context);
            if (future == null) continue;
            this.cancellableActions.add(future);
        }
    }

    protected void executeAction(Action<S, E> action, StateContext<S, E> context) {
        long now = System.currentTimeMillis();
        action.execute(context);
        if (this.actionListener != null) {
            try {
                this.actionListener.onExecute(context.getStateMachine(), action, System.currentTimeMillis() - now);
            }
            catch (Exception e) {
                log.warn((Object)"Error with actionListener", (Throwable)e);
            }
        }
    }

    protected ScheduledFuture<?> scheduleAction(final Action<S, E> action, final StateContext<S, E> context) {
        TaskScheduler taskScheduler = this.getTaskScheduler();
        if (taskScheduler == null) {
            log.error((Object)("Unable to schedule action as taskSchedule is not set, action=[" + action + "]"));
            return null;
        }
        ScheduledFuture future = taskScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                AbstractState.this.executeAction(action, context);
            }
        }, new Date());
        return future;
    }

    public String toString() {
        return "AbstractState [id=" + this.id + ", pseudoState=" + this.pseudoState + ", deferred=" + this.deferred + ", entryActions=" + this.entryActions + ", exitActions=" + this.exitActions + ", stateActions=" + this.stateActions + ", regions=" + this.regions + ", submachine=" + this.submachine + "]";
    }
}

