/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.security;

import java.util.Collection;
import java.util.HashSet;
import org.springframework.util.StringUtils;

public class SecurityRule {
    private Collection<String> attributes;
    private ComparisonType comparisonType = ComparisonType.ANY;
    private String expression;

    public static String securityAttributesToCommaDelimitedList(Collection<?> attributes) {
        return StringUtils.collectionToDelimitedString(attributes, (String)", ");
    }

    public static Collection<String> commaDelimitedListToSecurityAttributes(String attributes) {
        HashSet<String> attrs = new HashSet<String>();
        for (String attribute : attributes.split(",")) {
            if ("".equals(attribute = attribute.trim())) continue;
            attrs.add(attribute);
        }
        return attrs;
    }

    public Collection<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<String> attributes) {
        this.attributes = attributes;
    }

    public ComparisonType getComparisonType() {
        return this.comparisonType;
    }

    public void setComparisonType(ComparisonType comparisonType) {
        this.comparisonType = comparisonType;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String toString() {
        return "SecurityRule [attributes=" + this.attributes + ", comparisonType=" + (Object)((Object)this.comparisonType) + ", expression=" + this.expression + "]";
    }

    public static enum ComparisonType {
        ANY,
        ALL,
        MAJORITY;

    }
}

