/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.Ordered;
import org.springframework.statemachine.processor.MethodInvokingStateMachineRuntimeProcessor;
import org.springframework.statemachine.processor.StateMachineRuntime;
import org.springframework.statemachine.processor.StateMachineRuntimeProcessor;

public class StateMachineHandler<T extends Annotation, S, E>
implements Ordered {
    private final Class<?> beanClass;
    private final StateMachineRuntimeProcessor<?, S, E> processor;
    private final T metaAnnotation;
    private final Annotation annotation;
    private int order = Integer.MAX_VALUE;

    public StateMachineHandler(Class<?> beanClass, Object target, Method method, T metaAnnotation, Annotation annotation) {
        this(beanClass, metaAnnotation, annotation, new MethodInvokingStateMachineRuntimeProcessor(target, method));
    }

    public StateMachineHandler(Class<?> beanClass, Object target, String methodName, T metaAnnotation, Annotation annotation) {
        this(beanClass, metaAnnotation, annotation, new MethodInvokingStateMachineRuntimeProcessor(target, methodName));
    }

    public StateMachineHandler(Class<?> beanClass, T metaAnnotation, Annotation annotation, MethodInvokingStateMachineRuntimeProcessor<T, S, E> processor) {
        this.beanClass = beanClass;
        this.processor = processor;
        this.metaAnnotation = metaAnnotation;
        this.annotation = annotation;
    }

    public int getOrder() {
        return this.order;
    }

    public T getMetaAnnotation() {
        return this.metaAnnotation;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Object handle(StateMachineRuntime<S, E> stateMachineRuntime) {
        return this.processor.process(stateMachineRuntime);
    }

    public String toString() {
        return "StateMachineHandler [beanClass=" + this.beanClass + "]";
    }
}

