/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.guard;

import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.support.StateContextExpressionMethods;
import org.springframework.util.Assert;

public class SpelExpressionGuard<S, E>
implements Guard<S, E> {
    private final StateContextExpressionMethods methods;
    private final Expression expression;

    public SpelExpressionGuard(Expression expression) {
        Assert.notNull((Object)expression, (String)"Expression cannot be null");
        this.expression = expression;
        this.methods = new StateContextExpressionMethods(new StandardEvaluationContext());
    }

    @Override
    public boolean evaluate(StateContext<S, E> context) {
        return this.methods.getValue(this.expression, context, Boolean.class);
    }
}

