/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.impl;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.ProjectIssueTypeScreenSchemeHelper;
import com.atlassian.jira.optimizer.impl.ArchivedProjectSQLSearcher;
import com.atlassian.jira.optimizer.impl.recommendations.CustomFieldsProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class ArchivedProjectSearcher {
    private final ProjectManager projectManager;
    private final FieldScreenManager fieldScreenManager;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final ProjectIssueTypeScreenSchemeHelper projectIssueTypeScreenSchemeHelper;
    private final ArchivedProjectSQLSearcher archivedProjectSQLSearcher;
    private final CustomFieldsProvider customFieldsProvider;

    @Inject
    public ArchivedProjectSearcher(@ComponentImport ProjectManager projectManager, @ComponentImport FieldScreenManager fieldScreenManager, @ComponentImport FieldScreenSchemeManager fieldScreenSchemeManager, @ComponentImport ProjectIssueTypeScreenSchemeHelper projectIssueTypeScreenSchemeHelper, ArchivedProjectSQLSearcher archivedProjectSQLSearcher, CustomFieldsProvider customFieldsProvider) {
        this.projectManager = projectManager;
        this.fieldScreenManager = fieldScreenManager;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.projectIssueTypeScreenSchemeHelper = projectIssueTypeScreenSchemeHelper;
        this.archivedProjectSQLSearcher = archivedProjectSQLSearcher;
        this.customFieldsProvider = customFieldsProvider;
    }

    public List<Long> getArchivedProjectsUsingCf(CustomField customField) {
        if (this.projectManager.getArchivedProjects().isEmpty()) {
            return Collections.emptyList();
        }
        Set<Long> archivedProjects = this.customFieldsProvider.filterProjectsWithLocalContexts(customField, this.projectManager.getArchivedProjects()).stream().map(Project::getId).collect(Collectors.toSet());
        Set projectsInScreens = this.fieldScreenManager.getFieldScreens().stream().filter(fieldScreen -> fieldScreen.containsField(customField.getId())).map(arg_0 -> ((FieldScreenSchemeManager)this.fieldScreenSchemeManager).getFieldScreenSchemes(arg_0)).flatMap(Collection::stream).map(arg_0 -> ((ProjectIssueTypeScreenSchemeHelper)this.projectIssueTypeScreenSchemeHelper).getProjectsForFieldScreenScheme(arg_0)).flatMap(Collection::stream).map(Project::getId).collect(Collectors.toSet());
        archivedProjects.retainAll(projectsInScreens);
        if (archivedProjects.isEmpty()) {
            return Collections.emptyList();
        }
        return this.archivedProjectSQLSearcher.getArchivedProjectsUsingCfUsingSQL(customField, archivedProjects);
    }
}

