/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.indexanalyzer.impl;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.SimpleCollector;

public class IssueDataCollector
extends SimpleCollector {
    private Map<Long, Date> issueData = new HashMap<Long, Date>();
    private SortedDocValues issueIdDocValues;
    private NumericDocValues updatedDocValues;

    public void collect(int doc) throws IOException {
        if (this.issueIdDocValues.advanceExact(doc) && this.updatedDocValues.advanceExact(doc)) {
            this.issueData.put(Long.valueOf(this.issueIdDocValues.binaryValue().utf8ToString()), new Date(this.updatedDocValues.longValue()));
        }
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        LeafReader reader = context.reader();
        this.issueIdDocValues = reader.getSortedDocValues("issue_id");
        this.updatedDocValues = reader.getNumericDocValues("updated");
    }

    Map<Long, Date> getIssueData() {
        return this.issueData;
    }

    public boolean needsScores() {
        return false;
    }
}

