/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.indexanalyzer.impl;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.plugins.indexanalyzer.api.IndexAnalyzerBusyException;
import com.atlassian.jira.plugins.indexanalyzer.api.IndexAnalyzerGeneralException;
import com.atlassian.jira.plugins.indexanalyzer.api.IndexHealer;
import com.atlassian.jira.plugins.indexanalyzer.events.HealingCompletedEvent;
import com.atlassian.jira.plugins.indexanalyzer.impl.IndexAnalyzerLockingExecutor;
import com.atlassian.jira.plugins.indexanalyzer.model.AnalyzerResult;
import com.atlassian.jira.plugins.indexanalyzer.model.HealerResult;
import com.atlassian.jira.plugins.indexanalyzer.model.IssueData;
import com.atlassian.jira.plugins.indexanalyzer.model.OutdatedIssueData;
import com.atlassian.jira.util.StopWatch;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultIndexHealer
implements IndexHealer {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexHealer.class);
    private final EventPublisher eventPublisher;
    private final IssueManager issueManager;
    private final IssueIndexingService issueIndexingService;
    private final IndexAnalyzerLockingExecutor lockingExecutor;

    @Autowired
    public DefaultIndexHealer(@ComponentImport EventPublisher eventPublisher, @ComponentImport IssueManager issueManager, @ComponentImport IssueIndexingService issueIndexingService, IndexAnalyzerLockingExecutor lockingExecutor) {
        this.eventPublisher = eventPublisher;
        this.issueManager = issueManager;
        this.issueIndexingService = issueIndexingService;
        this.lockingExecutor = lockingExecutor;
    }

    @Override
    public boolean isBusy() {
        return this.lockingExecutor.isBusy();
    }

    @Override
    public HealerResult heal(AnalyzerResult analyzerResult) throws IndexAnalyzerGeneralException, IndexAnalyzerBusyException {
        return this.lockingExecutor.execute(() -> {
            StopWatch stopWatch = new StopWatch();
            ArrayList<Long> reindexedDbOrphansSuccessful = new ArrayList<Long>();
            ArrayList<Long> reindexedDbOrphansFailed = new ArrayList<Long>();
            ArrayList<Long> reindexedOutdatedSuccessful = new ArrayList<Long>();
            ArrayList<Long> reindexedOutdatedFailed = new ArrayList<Long>();
            ArrayList<Long> deindexedIndexOrphansSuccessful = new ArrayList<Long>();
            ArrayList<Long> deindexedIndexOrphansFailed = new ArrayList<Long>();
            log.info("Reindexing {} of {} issues missing from the index", (Object)analyzerResult.getDbOrphans().size(), (Object)analyzerResult.getDbOrphansCount());
            for (IssueData dbOrphan : analyzerResult.getDbOrphans()) {
                boolean reindexSuccessful = this.reindex(dbOrphan.getIssueId());
                ArrayList<Long> resultList = reindexSuccessful ? reindexedDbOrphansSuccessful : reindexedDbOrphansFailed;
                resultList.add(dbOrphan.getIssueId());
            }
            log.info("Done reindexing issues missing from the index");
            long reindexDbOrphansTimeMs = stopWatch.getIntervalTime();
            log.info("Reindexing {} of {} issues outdated in the index", (Object)analyzerResult.getOutdatedIssueData().size(), (Object)analyzerResult.getOutdatedIssueCount());
            for (OutdatedIssueData outdatedIssue : analyzerResult.getOutdatedIssueData()) {
                boolean reindexSuccessful = this.reindex(outdatedIssue.getIssueId());
                ArrayList<Long> resultList = reindexSuccessful ? reindexedOutdatedSuccessful : reindexedOutdatedFailed;
                resultList.add(outdatedIssue.getIssueId());
            }
            log.info("Done reindexing issues outdated in the index");
            long reindexOutdatedTimeMs = stopWatch.getIntervalTime();
            log.info("Deindexing {} of {} issues absent from the database", (Object)analyzerResult.getIndexOrphans().size(), (Object)analyzerResult.getIndexOrphansCount());
            for (IssueData indexOrphan : analyzerResult.getIndexOrphans()) {
                boolean deindexSuccessful = this.deindex(indexOrphan.getIssueId());
                ArrayList<Long> resultList = deindexSuccessful ? deindexedIndexOrphansSuccessful : deindexedIndexOrphansFailed;
                resultList.add(indexOrphan.getIssueId());
            }
            log.info("Done deindexing issues absent from the database");
            long deindexIndexOrphansTimeMs = stopWatch.getIntervalTime();
            this.eventPublisher.publish((Object)new HealingCompletedEvent(reindexedDbOrphansSuccessful.size(), reindexedDbOrphansFailed.size(), reindexDbOrphansTimeMs, reindexedOutdatedSuccessful.size(), reindexedOutdatedFailed.size(), reindexOutdatedTimeMs, deindexedIndexOrphansSuccessful.size(), deindexedIndexOrphansFailed.size(), deindexIndexOrphansTimeMs));
            return new HealerResult(reindexedDbOrphansSuccessful, reindexedDbOrphansFailed, reindexedOutdatedSuccessful, reindexedOutdatedFailed, deindexedIndexOrphansSuccessful, deindexedIndexOrphansFailed);
        });
    }

    private boolean reindex(Long issueId) {
        MutableIssue issueObject = this.issueManager.getIssueObject(issueId);
        try {
            log.info("Reindexing issue, issueId={}, issueKey={}", (Object)issueId, (Object)issueObject.getKey());
            this.issueIndexingService.reIndexIssueObjects(Collections.singletonList(issueObject), IssueIndexingParams.INDEX_ALL, false);
            return true;
        }
        catch (IndexException e) {
            log.error("Failed to reindex issue issueId={}, issueKey={}", new Object[]{issueId, issueObject.getKey(), e});
            return false;
        }
    }

    private boolean deindex(Long issueId) {
        try {
            log.info("Deindexing issue, issueId={}", (Object)issueId);
            this.issueIndexingService.deIndexIssueObjectsById(Collections.singleton(() -> issueId), false);
            return true;
        }
        catch (IndexException e) {
            log.error("Failed to deindex issue issueId={}", (Object)issueId, (Object)e);
            return false;
        }
    }
}

