/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.web;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.plugins.importer.github.config.ConfigBean;
import com.atlassian.jira.plugins.importer.github.web.GithubImportProcessSupport;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.github.core.Label;
import webwork.action.ActionContext;

public class GithubLabelMappingPage
extends GithubImportProcessSupport {
    public GithubLabelMappingPage(@ComponentImport UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ProjectManager projectManager, @ComponentImport IssueTypeSchemeManager issueTypeSchemeManager, @ComponentImport WorkflowSchemeManager workflowSchemeManager) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, projectManager, issueTypeSchemeManager, workflowSchemeManager);
    }

    public boolean displayIssueTypeWarning() {
        return this.getFieldConfigScheme().isPresent();
    }

    public String getIssueTypeSchemeName() {
        Optional<FieldConfigScheme> fieldConfigScheme = this.getFieldConfigScheme();
        return fieldConfigScheme.isPresent() ? ((FieldConfigScheme)fieldConfigScheme.get()).getName() : "???";
    }

    private Optional<FieldConfigScheme> getFieldConfigScheme() {
        Iterable schemes = Iterables.transform(this.getExistingDestinationProjects(), (Function)new Function<Project, FieldConfigScheme>(){

            public FieldConfigScheme apply(Project input) {
                return GithubLabelMappingPage.this.issueTypeSchemeManager.getConfigScheme(input);
            }
        });
        return Optional.fromNullable((Object)Iterables.getFirst((Iterable)Iterables.filter((Iterable)schemes, (Predicate)Predicates.notNull()), null));
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.isNextClicked()) {
            this.getConfigBean().setAutoLabels(ActionContext.getParameters().containsKey("autoLabels"));
            this.populateLabelMappings();
            this.setDefaultIssueTypes();
        }
        if (this.isPreviousClicked()) {
            return this.getRedirect(this.getImporterBaseUrlWithSlash() + "GithubProjectMappingPage!default.jspa?externalSystem=" + this.getExternalSystem() + "&atl_token=" + this.getXsrfToken());
        }
        return super.doExecute();
    }

    private void setDefaultIssueTypes() {
        ConfigBean configBean = this.getConfigBean();
        HashMap defaultIssueTypes = Maps.newHashMap();
        for (String selectedProject : configBean.getSelectedProjects()) {
            String projectKey = configBean.getProjectKey(selectedProject);
            Project project = this.projectManager.getProjectObjByKey(projectKey);
            if (project == null) {
                this.issueTypeSchemeManager.getDefaultIssueTypeScheme();
                FieldConfig defaultSchemeConfig = this.issueTypeSchemeManager.getDefaultIssueTypeScheme().getOneAndOnlyConfig();
                IssueType defaultValue = this.issueTypeSchemeManager.getDefaultValue(defaultSchemeConfig);
                defaultIssueTypes.put(projectKey, defaultValue);
                continue;
            }
            IssueType defaultIssueType = this.issueTypeSchemeManager.getDefaultIssueType(project);
            if (defaultIssueType != null) {
                defaultIssueTypes.put(projectKey, defaultIssueType);
                continue;
            }
            IssueType firstIssueType = (IssueType)this.issueTypeSchemeManager.getIssueTypesForProject(project).iterator().next();
            defaultIssueTypes.put(projectKey, firstIssueType);
        }
        configBean.setDefaultIssueTypesForProjectKey(defaultIssueTypes);
    }

    private void populateLabelMappings() {
        ConfigBean configBean = this.getConfigBean();
        List<Label> labels = configBean.getGithubDataService().getLabels();
        Iterable labelNames = Iterables.transform(labels, (Function)new Function<Label, String>(){

            public String apply(Label input) {
                return input.getName();
            }
        });
        configBean.setIssueTypeMapping(this.getMapping(labelNames, "typeMapping_"));
        configBean.setResolutionMappings(this.getMapping(labelNames, "resolutionMapping_"));
    }

    private Map<String, Integer> getMapping(Iterable<String> labelNames, final String mappingPrefix) {
        HashMap mapping = Maps.newHashMap();
        Function<String, Integer> labelToId = new Function<String, Integer>(){

            public Integer apply(String input) {
                String typeId = ParameterUtils.getStringParam((Map)ActionContext.getParameters(), (String)(mappingPrefix + input));
                return this.intOrNull(typeId);
            }

            private Integer intOrNull(String value) {
                try {
                    return new Integer(value);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        };
        for (String labelName : labelNames) {
            Integer value = (Integer)labelToId.apply((Object)labelName);
            if (value == null) continue;
            mapping.put(labelName, value);
        }
        return ImmutableMap.copyOf((Map)mapping);
    }

    public String getFormTitle() {
        return this.getText("com.atlassian.jira.plugins.importer.github.labelmapping.title");
    }

    public Map<String, String> getJiraIssueTypeValues() {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        for (IssueType issueType : this.getAllowedIssueTypes()) {
            options.put(issueType.getId(), issueType.getNameTranslation());
        }
        return options;
    }

    private Iterable<IssueType> getAllowedIssueTypes() {
        List<Project> existingDestinationProjects = this.getExistingDestinationProjects();
        if (existingDestinationProjects.size() > 0) {
            Project project = existingDestinationProjects.get(0);
            return this.issueTypeSchemeManager.getNonSubTaskIssueTypesForProject(project);
        }
        return Iterables.filter((Iterable)this.issueTypeSchemeManager.getIssueTypesForDefaultScheme(), (Predicate)new Predicate<IssueType>(){

            public boolean apply(IssueType input) {
                return !input.isSubTask();
            }
        });
    }

    public Map<String, String> getJiraIssueResolutionValues() {
        ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        for (Resolution resolution : constantsManager.getResolutionObjects()) {
            options.put(resolution.getId(), resolution.getNameTranslation());
        }
        return options;
    }

    public String getSelectedIssueTypeMapping(String label) {
        Integer value = this.getConfigBean().getIssueTypeMapping().get(label);
        return value != null ? value.toString() : "";
    }

    public String getSelectedIssueResolutionMapping(String label) {
        Integer value = this.getConfigBean().getResolutionMappings().get(label);
        return value != null ? value.toString() : "";
    }
}

