/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.web;

import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.github.GithubImportProcessBean;
import com.atlassian.jira.plugins.importer.github.config.ConfigBean;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.ImporterProcessSupport;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;

public abstract class GithubImportProcessSupport
extends ImporterProcessSupport {
    protected final ProjectManager projectManager;
    protected final IssueTypeSchemeManager issueTypeSchemeManager;
    protected final WorkflowSchemeManager workflowSchemeManager;

    public GithubImportProcessSupport(@ComponentImport UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ProjectManager projectManager, @ComponentImport IssueTypeSchemeManager issueTypeSchemeManager, @ComponentImport WorkflowSchemeManager workflowSchemeManager) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.projectManager = projectManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.workflowSchemeManager = workflowSchemeManager;
    }

    @Nullable
    protected GithubImportProcessBean getProcessBean() {
        ImporterController controller = this.getController();
        if (controller == null) {
            throw new RuntimeException("Unknown Controller");
        }
        ImportProcessBean processBean = controller.getImportProcessBeanFromSession();
        if (processBean == null || !(processBean instanceof GithubImportProcessBean)) {
            return null;
        }
        return (GithubImportProcessBean)controller.getImportProcessBeanFromSession();
    }

    public ConfigBean getConfigBean() {
        return this.getProcessBean() != null ? (ConfigBean)this.getProcessBean().getConfigBean() : null;
    }

    protected List<Project> getExistingDestinationProjects() {
        Iterable existingProjects = Iterables.transform(this.getConfigBean().getSelectedProjects(), (Function)new Function<String, Project>(){

            public Project apply(String input) {
                String projectKey = GithubImportProcessSupport.this.getConfigBean().getProjectKey(input);
                if (projectKey == null) {
                    return null;
                }
                return GithubImportProcessSupport.this.projectManager.getProjectObjByKey(projectKey);
            }
        });
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)existingProjects, (Predicate)Predicates.notNull()));
    }
}

