/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.web;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

public class GithubSetupPage
extends AbstractSetupPage {
    private String githubUsername = "";
    private String githubPassword = "";
    private String githubUrl = "";
    private String githubToken = "";
    private boolean githubClassic = true;

    public void setGithubUsername(String githubUsername) {
        this.githubUsername = githubUsername;
    }

    public void setGithubPassword(String githubPassword) {
        this.githubPassword = githubPassword;
    }

    public void setGithubUrl(String githubUrl) {
        this.githubUrl = githubUrl;
    }

    public void setGithubClassic(boolean githubClassic) {
        this.githubClassic = githubClassic;
    }

    public void setGithubToken(String githubToken) {
        this.githubToken = githubToken;
    }

    public String getGithubUsername() {
        return this.githubUsername;
    }

    public String getGithubToken() {
        return this.githubToken;
    }

    public String getGithubPassword() {
        return this.githubPassword;
    }

    public String getGithubUrl() {
        return this.githubUrl;
    }

    public boolean isGithubClassic() {
        return this.githubClassic;
    }

    public GithubSetupPage(@ComponentImport UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport EventPublisher eventPublisher) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, eventPublisher);
    }

    protected void doValidation() {
        if (!(this.isPreviousClicked() || this.githubClassic || this.isUrlValid())) {
            this.addErrorMessage(this.getText("com.atlassian.jira.plugins.importer.github.error.incorrect.url"));
        }
        super.doValidation();
    }

    public boolean isUrlValid() {
        try {
            URL u = new URL(this.githubUrl);
            if (!"http".equals(u.getProtocol()) && !"https".equals(u.getProtocol())) {
                return false;
            }
            this.githubUrl = StringUtils.chomp((String)u.toString(), (String)"/");
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    protected String doExecute() throws Exception {
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        if (this.hasAnyErrors()) {
            return "input";
        }
        if (!this.isPreviousClicked() && !controller.createImportProcessBean((AbstractSetupPage)this)) {
            return "input";
        }
        return super.doExecute();
    }
}

