/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.rest;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugins.importer.extensions.ExternalSystemImporterModuleDescriptor;
import com.atlassian.jira.plugins.importer.github.GithubImportProcessBean;
import com.atlassian.jira.plugins.importer.github.GithubImporterController;
import com.atlassian.jira.plugins.importer.github.fetch.DataFetchJob;
import com.atlassian.jira.plugins.importer.github.fetch.FetchProgress;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

@Path(value="fetchData")
public class FetchDataResource {
    private final Logger log = Logger.getLogger(this.getClass());
    private final JiraAuthenticationContext authenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final PluginAccessor pluginAccessor;

    public FetchDataResource(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport PluginAccessor pluginAccessor) {
        this.authenticationContext = authenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.pluginAccessor = pluginAccessor;
    }

    @GET
    @Path(value="/{externalSystem}/progress")
    @Produces(value={"application/json"})
    public Response getProgress(@Context HttpServletRequest req, @PathParam(value="externalSystem") String externalSystem) {
        if (!this.isAdministrator()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.log.debug((Object)"Returning data fetch progress");
        HttpSession session = req.getSession(false);
        GithubImporterController controller = this.getController(externalSystem);
        if (session == null || controller == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No active importer found").build();
        }
        GithubImportProcessBean githubImportProcessBean = (GithubImportProcessBean)controller.getImportProcessBean(session);
        if (githubImportProcessBean != null && githubImportProcessBean.getDataFetchJob() != null) {
            DataFetchJob dataFetchJob = githubImportProcessBean.getDataFetchJob();
            String json = this.toJSON(dataFetchJob.getFetchProgress());
            return Response.ok((Object)json).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No data fetch operation has been started").build();
    }

    @POST
    @Path(value="/{externalSystem}/cancel")
    public Response cancel(@Context HttpServletRequest req, @PathParam(value="externalSystem") String externalSystem) {
        if (!this.isAdministrator()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.log.debug((Object)"Canceling data fetch");
        HttpSession session = req.getSession(false);
        GithubImporterController controller = this.getController(externalSystem);
        if (session == null || controller == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No active importer found").build();
        }
        GithubImportProcessBean githubImportProcessBean = (GithubImportProcessBean)controller.getImportProcessBean(session);
        if (githubImportProcessBean != null && githubImportProcessBean.getDataFetchJob() != null) {
            DataFetchJob dataFetchJob = githubImportProcessBean.getDataFetchJob();
            dataFetchJob.cancel();
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No data fetch operation has been started").build();
    }

    protected boolean isAdministrator() {
        User currentUser = this.authenticationContext.getLoggedInUser();
        return currentUser != null && this.globalPermissionManager.hasPermission(0, currentUser);
    }

    private GithubImporterController getController(String externalSystem) {
        ExternalSystemImporterModuleDescriptor moduleDescriptor = (ExternalSystemImporterModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(externalSystem);
        if (moduleDescriptor == null) {
            throw new RuntimeException("No active ImporterController found");
        }
        return (GithubImporterController)((Object)moduleDescriptor.getModule());
    }

    private String toJSON(FetchProgress fetchProgress) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)fetchProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

