/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.importer.markup;

import com.atlassian.jira.plugins.importer.github.importer.markup.SimpleConverter;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class SimpleSyntax
implements SimpleConverter {
    private static final MarkdownChanger[] CHANGERS = new MarkdownChanger[]{new MarkdownChanger("\r\n", new Replace("\n")), new MarkdownChanger("^(#+)(?=[^\\d])", 8, (Function)new Function<MatchResult, Optional<String>>(){

        public Optional<String> apply(MatchResult input) {
            String group = input.group(1);
            if (group.length() <= 6) {
                return Optional.of((Object)("h" + group.length() + "."));
            }
            return Optional.absent();
        }
    }), new MarkdownChanger("^(.+?)\n([-=]+)$", 8, (Function)new Function<MatchResult, Optional<String>>(){

        public Optional<String> apply(MatchResult input) {
            int headerLevel = input.group(2).charAt(0) == '=' ? 1 : 2;
            String result = String.format("h%d. %s", headerLevel, input.group(1));
            return Optional.of((Object)result);
        }
    }), new MarkdownChanger("^[-\\*_]{3,}\\s*?$", 8, new Replace("----")), new MarkdownChanger("([\\*_]+)(.+?)\\1", (Function)new Function<MatchResult, Optional<String>>(){

        public Optional<String> apply(MatchResult input) {
            String character = input.group(1).length() == 2 ? "*" : "_";
            return Optional.of((Object)(character + "$2" + character));
        }
    }), new MarkdownChanger("~~(.+?)~~", new Replace("-$1-")), new MarkdownChanger("`(.+?)`", new Replace("{{$1}}"))};

    @Override
    public String convertMarkdown(String content) {
        String transformedResult = content;
        for (MarkdownChanger changer : CHANGERS) {
            Pattern pattern = changer.pattern;
            Function replaceFunction = changer.replaceFunction;
            StringBuffer buffer = new StringBuffer();
            Matcher matcher = pattern.matcher(transformedResult);
            while (matcher.find()) {
                Optional replacement = (Optional)replaceFunction.apply((Object)matcher);
                if (!replacement.isPresent()) continue;
                matcher.appendReplacement(buffer, (String)replacement.get());
            }
            matcher.appendTail(buffer);
            transformedResult = buffer.toString();
        }
        return transformedResult;
    }

    private static class Replace
    implements Function<MatchResult, Optional<String>> {
        private Optional<String> literal;

        private Replace(String literal) {
            this.literal = Optional.fromNullable((Object)literal);
        }

        public Optional<String> apply(@Nullable MatchResult input) {
            return this.literal;
        }
    }

    private static class MarkdownChanger {
        private Pattern pattern;
        private Function<MatchResult, Optional<String>> replaceFunction;

        private MarkdownChanger(String regex, Function<MatchResult, Optional<String>> replaceFunction) {
            this.pattern = Pattern.compile(regex);
            this.replaceFunction = replaceFunction;
        }

        private MarkdownChanger(String regex, int flags, Function<MatchResult, Optional<String>> replaceFunction) {
            this.pattern = Pattern.compile(regex, flags);
            this.replaceFunction = replaceFunction;
        }
    }
}

