/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.importer;

import com.atlassian.jira.plugins.importer.external.beans.ExternalAttachment;
import com.atlassian.jira.plugins.importer.github.fetch.RemoteCall;
import com.atlassian.jira.plugins.importer.github.importer.Attachment;
import com.atlassian.jira.plugins.importer.github.util.GithubRequestService;
import com.atlassian.jira.plugins.importer.github.util.HttpClientFactory;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.util.AttachmentUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.log4j.Logger;

public class AttachmentManager {
    public List<ExternalAttachment> downloadAttachmentsForIssue(Iterable<Attachment> attachments, ImportLogger importLogger) {
        ArrayList<ExternalAttachment> externalAttachments = new ArrayList<ExternalAttachment>();
        if (attachments != null) {
            for (Attachment attachment : attachments) {
                importLogger.log("Downloading attachment " + attachment.getFilename() + " from " + attachment.getDownloadUrl(), new Object[0]);
                Download download = null;
                try {
                    download = this.downloadFile(attachment.getDownloadUrl(), importLogger);
                }
                catch (IOException e) {
                    throw new RuntimeException("Giving up to download attachments", e);
                }
                if (download != null) {
                    ExternalAttachment externalAttachment = new ExternalAttachment(attachment.getFilename(), download.getFile(), download.getLastModified());
                    externalAttachments.add(externalAttachment);
                    continue;
                }
                importLogger.warn("Unable to download " + attachment.getDownloadUrl(), new Object[0]);
            }
        }
        return externalAttachments;
    }

    private Download downloadFile(final String url, final ImportLogger importLogger) throws IOException {
        GithubRequestService requestService = new GithubRequestService(new GithubRequestService.FailureCallback(){

            @Override
            public void retry(String msg) {
                importLogger.warn(msg, new Object[0]);
            }

            @Override
            public void retriesFinished() {
                importLogger.log("Successfully downloaded " + url + " after retries", new Object[0]);
            }
        }, 10, null);
        try {
            return requestService.submit(new DownloadRemoteCall(url));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Download {
        private File file;
        private Date lastModified;

        private Download() {
        }

        public File getFile() {
            return this.file;
        }

        public Date getLastModified() {
            return this.lastModified;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public void setLastModified(Date lastModified) {
            this.lastModified = lastModified;
        }
    }

    private static class DownloadRemoteCall
    implements RemoteCall<Download> {
        private final Logger log = Logger.getLogger(this.getClass());
        private String url;

        private DownloadRemoteCall(String url) {
            this.url = url;
        }

        @Override
        public Download call() throws IOException {
            Download download = new Download();
            HttpGet request = new HttpGet(this.url);
            HttpResponse response = HttpClientFactory.createHttpClient().execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                String lastModifiedStr = response.getFirstHeader("Last-Modified").getValue();
                try {
                    download.setLastModified(DateUtils.parseDate((String)lastModifiedStr));
                }
                catch (DateParseException e) {
                    this.log.error((Object)e);
                    download.setLastModified(new Date());
                }
                InputStream input = response.getEntity().getContent();
                File file = this.getTempFile();
                FileOutputStream output = new FileOutputStream(file);
                IOUtils.copy((InputStream)input, (OutputStream)output);
                input.close();
                ((OutputStream)output).close();
                download.setFile(file);
                return download;
            }
            return null;
        }

        private File getTempFile() throws IOException {
            File tempDir = AttachmentUtils.getTemporaryAttachmentDirectory();
            File file = File.createTempFile("githubAttachment-", ".tmp", tempDir);
            if (file.getParentFile() != null) {
                FileUtils.forceMkdir((File)file.getParentFile());
            }
            return file;
        }
    }
}

