package com.atlassian.jira.plugins.importer.github.importer.markup;

import com.atlassian.jira.plugins.importer.github.importer.Attachment;
import com.google.common.base.Objects;

import java.util.Set;

public class ConversionResult {
	private Set<Attachment> attachments;
	private String convertedContent;

	ConversionResult(Set<Attachment> attachments, String convertedContent) {
		this.attachments = attachments;
		this.convertedContent = convertedContent;
	}

	public Set<Attachment> getAttachments() {
		return attachments;
	}

	public String getConvertedContent() {
		return convertedContent;
	}

	@Override
	public String toString() {
		return Objects.toStringHelper(this)
				.add("attachments", attachments)
				.add("convertedContent", convertedContent).toString();
	}
}
