define("jira/editor/plugins/toolbar-sync", [
    "jira/editor/tinymce",
], function (tinymce) {
    "use strict";

    var highlighted = ["bold", "italic", "underline"];

    tinymce.create('tinymce.plugins.jira.ToolbarSyncPlugin', {
        init: function (ed) {
            var settings = ed.settings;

            ed.on('NodeChange', function () {
                if (ed.isHidden()) {
                    return;
                }

                highlighted.forEach(function(operation) {
                    var queryStatus = ed.queryCommandState(operation);
                    var $op = settings.toolbarContainer.find("[data-operation="+operation+"]");
                    var currentStatus = !!$op.attr('aria-pressed');
                    if (currentStatus !== queryStatus) {
                        $op.attr('aria-pressed', queryStatus ? 'true' : null);
                    }
                })
            });

            ed.on('hide', function () {
                highlighted.forEach(function(operation) {
                    settings.toolbarContainer.find("[data-operation="+operation+"]").attr('aria-pressed', null);
                });
            });

            ed.contextManager.on("change:all", function(e) {
                // disable all buttons and dropdowns
                settings.toolbarContainer.find("[aria-disabled], [data-operation], [aria-controls]").attr("aria-disabled", e.disableState);
            });

            ed.contextManager.on("change:a", function(e) {
                settings.toolbarContainer.find("[data-operation^=link]").attr("aria-disabled", e.disableState);
            });

            ed.contextManager.on("change:table", function(e) {
                settings.toolbarContainer.find("[data-operation=table]").attr("aria-disabled", e.disableState);
            });
        }
    });

    tinymce.PluginManager.add('jira.toolbarsync', tinymce.plugins.jira.ToolbarSyncPlugin);
    tinymce.PluginManager.urls["jira.toolbarsync"] = true;

    return {
        configure: function (instance, settings) {
            settings.plugins.push('jira.toolbarsync');
            settings.toolbarContainer = instance.element.getToolbarContainer();

        }
    };
});
