define("jira/editor/instance",["jira/dialog/dialog","jira/editor/analytics","jira/editor/analytics-shortcuts","jira/util/navigator","jira/editor/tinymce","jira/editor/context-manager","jira/editor/context-detector","jira/editor/schema","jira/editor/selection","wiki-edit/SpeechRecognition","jira/util/logger","jquery","backbone","underscore","wrm/context-path"],function(h,j,a,f,d,q,l,m,i,b,r,g,c,p,k){var n=function(t,s){this.element=t;this.options=p.extend({},s)};p.extend(n.prototype,c.Events);var e=27;n.prototype.init=function(t){this.editor=t;this.operationOverride={};this.analyticsShortcuts=new a(this.editor);this.selection=new i(this.editor);this.editor.on("NodeChange",function(x){var v=j.startMeasure();if(!x){return}if(x.element.nodeName.toLowerCase()==="img"){this.editor.fire("content")}var w=g(x.element);this.trigger("selection:update",{insidePreformatted:l.detectPre(w),preformattedSelected:l.detectPreWithinSelection(this.editor.selection.getContent()),insideTable:l.detectTable(w),insideA:l.detectA(w)});v.measure("nodechange")}.bind(this));this.editor.on("change SetContent blur",this._onChange.bind(this));this.editor.on("keyup",p.debounce(this._onChange.bind(this),1000));this.editor.on("init",function(w){var v=w.target;["tt","del","sup","sub","cite"].forEach(function(y){v.formatter.register(y,{block:y,remove:"all"})});var x=v.formatter.get("removeformat");if(x.length>0&&typeof x[0]==="object"){x[0].selector+=",tt"}});t.on("keydown",function(v){if(v.isDefaultPrevented()){return}const w=g(t.selection.getStart());if(o(v,w)){v.preventDefault();t.execCommand("InsertLineBreak",false,v)}if(h.current&&v.keyCode===e){h.current.hide(true,{reason:h.HIDE_REASON.cancel,})}if(v.keyCode===d.util.VK.ENTER&&(w.is("panel-title, panel-title *")||w.parent().hasClass("panelHeader"))){v.preventDefault()}});var s=function(){if((/(Edge)\/(\d+)\.(\d+)/).test(f._getUserAgent())){return"edge"}else{if(f.isIE()){return"ie"}else{if(f.isChrome()){return"chrome"}else{if(f.isMozilla()){return"firefox"}else{if(f.isSafari()){return"safari"}}}}}return""};j.sendEvent("editor.instance.init");j.sendEvent("bundled.editor.instance.init");var u=s();if(u){j.sendEvent("editor.instance.init."+u)}this.contextManager=new q(this);t.contextManager=this.contextManager};n.prototype.getId=function(){return this.editor.id};n.prototype.relayEvent=function(t,u,s){this.editor.on(t,function(v){u(v)},s)};n.prototype.getAllowedOperations=function(){return["paragraph","h1","h2","h3","h4","h5","h6","monospace","paragraph-quote","block-quote","delete","superscript","subscript","cite","monospace-inline",":)",":(",":P",":D",";)","(y)","(n)","(i)","(/)","(x)","(!)","(+)","(-)","(?)","(on)","(off)","(*)","(*r)","(*g)","(*b)","(*y)","bold","italic","underline","color","bullet-list","numbered-list","mention","table","code","noformat","panel","hr","speech","link","link-mail","link-anchor","link-attachment","image","image-attachment","attachment","editorInsertContent","editorInsertContentInNewLine","editorReplaceContent","editorReplaceContentInNewLine"]};n.prototype._isOperationSupported=function(s){var t=this.getAllowedOperations().filter(function(u){if(u instanceof Object){return u.name===s}else{return u===s}});return t.length>0};n.prototype._assertOperationIsSupported=function(s){if(!this._isOperationSupported(s)){r.error("Operation not supported:",s)}};n.prototype._selectedTextSanitized=function(){return m.sanitizeHtml(this.editor.selection.getContent(),this.editor,this.pasteInsidePreSchemaSpec)};n.prototype.executeOperation=function(B,y){this._assertOperationIsSupported(B);var u=this._mapOperationNameToTinymce(B);var z=this.operationOverride[B];if(z){j.sendEvent("editor.instance.operation."+B);z(y);return true}if("editorReplaceContentInNewLine"===B){this.editor.execCommand("mceReplaceContent",false,"<br />"+y.content)}else{if("editorReplaceContent"===B){this.editor.execCommand("mceReplaceContent",false,y.content)}else{if("editorInsertContentInNewLine"===B){this.editor.insertContent("<br />"+y.content)}else{if("editorInsertContent"===B){this.editor.insertContent(y.content)}else{if("hr"===B){this.editor.insertContent("<hr />")}else{if("color"===B){this.editor.execCommand("ForeColor",true,y)}else{if(["h1","h2","h3","h4","h5","h6","paragraph","paragraph-quote","block-quote","monospace","monospace-inline","cite"].indexOf(B)>-1){this.editor.execCommand("mceToggleFormat",true,u)}else{if(["bold","italic","underline","delete","superscript","subscript"].indexOf(B)>-1){if(this.selection.trimSelection()){if(!this.selection.hasSelection()){j.sendEvent("editor.instance.selection.collapsed",{op:B});return false}else{j.sendEvent("editor.instance.selection.trimmed",{op:B})}}this.editor.execCommand(u,true)}else{if(["bullet-list","numbered-list"].indexOf(B)>-1){this.editor.execCommand(u,true)}else{if(this._emoticonSourceMap(B)){var A;if(AJS&&AJS.contextPath){A=AJS.contextPath()}else{A=""}var x=A+"/images/icons/emoticons/"+this._emoticonSourceMap(B);this.editor.insertContent('<img class="emoticon" src="'+x+'" height="16" width="16" align="absmiddle" alt="" border="0">')}else{if("link"===B){var w=(this._selectedTextSanitized()||AJS.I18n.getText("jira.wiki.editor.operation.link.external.placeholder"));this.editor.selection.setContent("["+w+"|http://example.com]")}else{if("link-anchor"===B){var w=(this._selectedTextSanitized()||AJS.I18n.getText("jira.wiki.editor.operation.link.anchor.placeholder"));this.editor.selection.setContent("[#"+w+"]")}else{if("link-mail"===B){var w=(this._selectedTextSanitized()||"mail@example.com");this.editor.selection.setContent("[mailto:"+w+"]")}else{if("mention"===B){var w=(this._selectedTextSanitized()||AJS.I18n.getText("jira.wiki.editor.operation.userMention.placeholder"));this.editor.selection.setContent("@");var t=this.getSelectionStart();this.editor.selection.setContent(w);this.setSelectionStart(t)}else{if("attachment"===B&&y.attachment){if(y.attachment.type==="image"){var s=y.attachment.href||k()+"/images/icons/attach/image.gif";if(y.attachment.thumbnailable){s=s.replace("/attachment/","/thumbnail/")}var v=JIRA.Editor.Tags.Templates.attachedImage({source:s,filename:y.attachment.name})}else{var v=JIRA.Editor.Tags.Templates.attachedFile({title:y.attachment.name,href:y.attachment.href,filename:y.attachment.name})}this.editor.insertContent(v)}else{if("code"===B){var w=(this._selectedTextSanitized()||AJS.I18n.getText("jira.editor.macro.code.placeholder")+"\n");this.editor.selection.setContent('<pre class="code panel" data-language="code-java">'+w+"</pre>")}else{if("panel"===B){var w=(this.editor.selection.getContent()||AJS.I18n.getText("jira.wiki.editor.operation.panel.placeholder"));this.editor.selection.setContent('<div class="plain panel" style="border-width: 1px;"><panel-title>'+AJS.I18n.getText("jira.wiki.editor.operation.panel.placeholder.title")+"</panel-title><p>"+w+"</p></div>")}else{if("noformat"===B){var w=(this._selectedTextSanitized()||AJS.I18n.getText("jira.wiki.editor.operation.noFormat.placeholder"));this.editor.selection.setContent('<pre class="noformat panel">'+w+"</pre>")}else{if("table"===B){var w=(this.editor.selection.getContent()||(AJS.I18n.getText("jira.wiki.editor.operation.table.placeholder.column")+" A1"));this.editor.selection.setContent('<div class="table-wrap"><table class="confluenceTable mce-item-table" data-mce-selected="1"><tbody><tr><th class="confluenceTh">'+AJS.I18n.getText("jira.wiki.editor.operation.table.placeholder.heading")+' 1</th><th class="confluenceTh">'+AJS.I18n.getText("jira.wiki.editor.operation.table.placeholder.heading")+' 2</th></tr><tr><td class="confluenceTd">'+w+'</td><td class="confluenceTd">Col A2</td></tr></tbody></table></div>');j.sendEvent("editor.instance.table.toolbar")}else{if("speech"===B){b.start(null,this)}else{if(["link-attachment","image","image-attachment"].indexOf(B)>-1){r.warn("Not supported yet "+B);return false}else{r.warn("Unsupported operation "+B);return false}}}}}}}}}}}}}}}}}}}}}j.sendEvent("editor.instance.operation."+B);this.trigger("content");r.trace("jira.editor.operation.executed");return true};n.prototype._mapOperationNameToTinymce=function(s){var t={bold:"Bold",italic:"Italic",underline:"Underline","bullet-list":"InsertUnorderedList","numbered-list":"InsertOrderedList",blockquote:"mceBlockQuote",paragraph:"p","paragraph-quote":"blockquote","block-quote":"blockquote",monospace:"samp","monospace-inline":"samp-inline","delete":"strikethrough",superscript:"superscript",subscript:"subscript"};if(s in t){return t[s]}return s};n.prototype._emoticonSourceMap=function(t){var s={":)":"smile.png",":(":"sad.png",":P":"tongue.png",":D":"biggrin.png",";)":"wink.png","(y)":"thumbs_up.png","(n)":"thumbs_down.png","(i)":"information.png","(/)":"check.png","(x)":"error.png","(!)":"warning.png","(+)":"add.png","(-)":"forbidden.png","(?)":"help_16.png","(on)":"lightbulb_on.png","(off)":"lightbulb.png","(*)":"star_yellow.png","(*r)":"star_red.png","(*g)":"star_green.png","(*b)":"star_blue.png","(*y)":"star_yellow.png","(flag)":"flag.png","(flagoff)":"flag_grey.png"};if(t in s){return s[t]}};n.prototype.focus=function(){if(!this.editor.initialized||this.editor.removed||this.editor.destroyed){r.warn("bypassing `editor-instance.focus` because the editor instance hasn't initialized yet or already removed");return this}this.editor.focus();this.editor.nodeChanged();return this};n.prototype.destroy=function(){this.editor.contextManager=null;this.editor.remove();j.sendEvent("editor.instance.destroy");j.sendEvent("bundled.editor.instance.destroy")};n.prototype.setContent=function(v,u,s){var t={};if(u){t={format:"raw"}}t.no_events=s;v=v||"";this.editor.setContent(v,t);this.lastContent=this.getContent();if(!s){this.trigger("content")}};n.prototype.replaceSelection=function(s){this.editor.selection.setContent(s);this.trigger("content")};n.prototype.selectAll=function(){this.editor.selection.select(this.editor.getBody(),true)};n.prototype.getSelectionStart=function(){return this.editor.selection.getRng(true)};n.prototype.setSelectionStart=function(t){var s=this.editor.selection.getRng(true);s.setStart(t.startContainer,t.startOffset);this.editor.selection.setRng(s)};n.prototype.getContent=function(t){var s={};if(t){s={format:"raw"}}return this.editor.getContent(s)};n.prototype._onChange=function(){if(this.editor.destroyed){return}var s=this.getContent();var t=s!==this.lastContent;this.lastContent=s;if(!this.hidden&&t){this.trigger("content",this.getContent())}};n.prototype.getSelectedContent=function(s){if(s){return this.editor.selection.getContent({format:"text"})}else{return this.editor.selection.getContent()}};n.prototype.addShortcut=function(s,t){this.editor.addShortcut(s,"",t)};n.prototype.removeShortcut=function(s){this.editor.shortcuts.remove(s)};n.prototype.addOperationOverride=function(s,t){this._assertOperationIsSupported(s);this.operationOverride[s]=t};n.prototype.removeOperationOverride=function(s){this._assertOperationIsSupported(s);delete this.operationOverrideoperationOverride[s]};n.prototype.hide=function(){this.hidden=true;this.editor.hide()};n.prototype.show=function(){this.editor.show();delete this.hidden};n.prototype.isVisible=function(){return !this.editor.isHidden()};n.prototype.switchMode=function(s){this.trigger("switchMode",s)};n.prototype.enable=function(){this.editor.setProgressState(false)};n.prototype.disable=function(){this.editor.setProgressState(true)};function o(t,u){const s="th, td, th *, td *";return t.keyCode===d.util.VK.ENTER&&!t.shiftKey&&u.is(s)}return n});