AJS.test.require(['com.atlassian.jira.plugins.jira-editor-plugin:controller'], function () {

    var $ = require("jquery");
    var Analytics = require("jira/editor/analytics");

    module("EditorConverterInstance", {
        setup: function () {
            this.controller = require('jira/editor/controller');
            this.formWithFormToken = $('<form><textarea/><input name="formToken" value="someFormToken"/></form>').appendTo('#qunit-fixture')[0];
            this.formWithoutFormToken = $('<form><textarea/></form>').appendTo('#qunit-fixture')[0];
        }
    });

    test('renderParams should return formToken', function () {
        var params = this.controller.getRenderParams($(this.formWithFormToken).find('textarea'));
        equal(params.formToken, "someFormToken");
    });

    test('renderParams should return "undefined" string when no formToken is present', function () {
        var params = this.controller.getRenderParams($(this.formWithoutFormToken).find('textarea'));
        equal(params.formToken, "undefined");
    });

    module("Test safari blur", {
        setUpModules: function () {
            this.context = AJS.test.mockableModuleContext();
            this.HeightHelper = function () {
                this.setHeights = function () {
                };
            };
            this.context.mock('jira/editor/height-helper', this.HeightHelper);
            this.wrmRequire = function () {
                return new $.Deferred().resolve();
            };
            this.context.mock('wrm/require', this.wrmRequire);
            var editorInstance = {
                on: function () {
                },
                relayEvent: function () {
                },
                setContent: function () {
                }
            };
            var builder = {
                withElement: function () {
                    return this
                },
                withMeta: function () {
                    return this
                },
                withPlugin: function () {
                    return this
                },
                build: function () {
                    return new $.Deferred().resolve(editorInstance);
                }
            };
            this.create = {
                builder: function () {
                    return builder;
                }
            };
            var SavingKbShortcuts = {
                enable: function () {
                }
            };
            this.context.mock('jira/editor/create', this.create);
            this.context.mock('jira/editor/analytics', Analytics);
            this.context.mock('jira/editor/saving-kb-shortcuts', SavingKbShortcuts);
            //there are internal require calls in tested code, this forces test to use mocked require handler
            window.require = this.context.require.bind(this.context);
            this.controller = this.context.require('jira/editor/controller');
        },

        setUpActors: function () {
            this.$richEditor = $('<rich-editor />');
            this.richEditor = this.$richEditor[0];
            this.richEditor.loadingStart = function () {
                return true;
            };
            this.richEditor.loadingStop = function () {
                return true;
            };
            this.richEditor.shouldFocus = function () {
                return false;
            };
            this.richEditor.hideMask = function () {
                return false;
            };

            this.$textarea = $('<textarea />');
            this.richEditor.$textarea = this.$textarea;
            this.toggleTabs = {
                enable: function () {
                },
                disable: function () {
                },
                on: function () {
                }
            };
            this.undoManager = {
                attachToVisualEditor: function () {
                },
                setActiveMode: function () {
                },
                restoreUndoHistory: function () {
                }
            };
            this.undoRedoButtons = {
                updateUI: function () {
                }
            };
        }, setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.setUpModules();
            this.setUpActors();
        },

        teardown: function () {
            this.sandbox.restore();
        },

        testBlur: function (assert, isSafari, shouldBlur) {
            assert.expect(2);
            var done = assert.async();
            $.browser.safari = isSafari;
            var activeElement = document.getElementsByTagName('body')[0];
            activeElement.focus();
            equal(document.activeElement, activeElement);
            this.sandbox.stub(activeElement, "blur");
            //last thing executed inside init handler
            this.sandbox.stub(Analytics, "oneShotMeasure", function (markStart, extraAttributes, eventName, keepEntries) {
                if (eventName === "init-bare") {
                    if (shouldBlur) {
                        sinon.assert.calledOnce(activeElement.blur);
                    } else {
                        sinon.assert.notCalled(activeElement.blur);
                    }
                    done();
                }
            });

            this.controller.initEditor(this.$richEditor, this.$textarea, this.toggleTabs, this.undoManager, this.undoRedoButtons, false);
        }
    });

    test('should blur focus on safari', function (assert) {
        this.testBlur(assert, true, true);
    });

    test('should not blur focus on other browsers', function (assert) {
        this.testBlur(assert, false, false);
    });
});