define("jira/editor/converter/handlers/table-handler", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/context-detector",
    "jira/editor/converter/new-lines/new-lines"
], function (
    NodeHandler,
    ContextDetector,
    NewLines
) {
    "use strict";

    /**
     * @class TableHandler
     * @extends NodeHandler
     */
    return NodeHandler.extend({
        init: function TableHandler(node) {
            this.node = node;
        },

        newLinesBefore: function () {
            var isNewLineRequired = ContextDetector.detectTable(this.node.previousElementSibling);
            return NewLines.single(!isNewLineRequired);
        }
    });
});