AJS.test.require([
    'com.atlassian.jira.plugins.jira-editor-plugin:registry',
    'com.atlassian.jira.plugins.jira-editor-plugin:fsm'
], function () {
    var $ = require("jquery");

    var Constants = require('jira/editor/constants');
    var Events = require('jira/editor/fsm/events');

    var Analytics = require('jira/editor/analytics');
    var FSM = require('jira/editor/fsm');
    var StateText = require('jira/editor/fsm/states/mode-text');
    var StateVisual = require('jira/editor/fsm/states/mode-visual');

    module('ContextDetector "pre"', {
        setup: function () {
            this.sandbox = sinon.sandbox.create();

            this.sendEvent = this.sandbox.stub(Analytics, "sendEvent");

            this.fsm = new FSM();

            this.context = AJS.test.mockableModuleContext();
            var stateHiddenIntersectionObserver = {
                isIntersectionObserverSupported: sinon.stub().returns(true),
                observe: sinon.stub().returns(true),
                cleanup: sinon.stub()
            };
            this.stateHiddenIntersectionObserver = stateHiddenIntersectionObserver;
            this.context.mock('jira/editor/fsm/states/state-hidden-intersection-observer', function () {
                return stateHiddenIntersectionObserver;
            });
            this.StateWrap = function () {
                return {
                    stateName: 'TestWrap'
                };
            };
            this.context.mock('jira/editor/fsm/states/wrap', this.StateWrap);
            this.StateHidden = this.context.require('jira/editor/fsm/states/hidden');

        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test('Should send event on transition between modes', function () {
        var now = 0;
        this.sandbox.stub(window.performance, "now", function() {
            return now;
        });

        var element = document.createElement('rich-editor');
        element.$textarea = $('<textarea></textarea>');
        var state = StateText(element);
        now += 1000;
        state = state(Events.TABS_CHANGE, Constants.Modes.VISUAL);
        equal(state.stateName, 'Visual', 'Transitioned to Visual');
        equal(this.sendEvent.getCalls().map(function(call) { return call.args[0] + " - " + call.args[1].time; }).join("\n"), "editor.instance.tab.timing.text - 1000");

        now += 2000;
        state = state(Events.TABS_CHANGE, Constants.Modes.TEXT);
        equal(state.stateName, 'Text', 'Transitioned to Text');
        equal(this.sendEvent.getCalls().map(function(call) { return call.args[0] + " - " + call.args[1].time; }).join("\n"),
            ["editor.instance.tab.timing.text - 1000", "editor.instance.tab.timing.visual - 2000"].join("\n"));
    });

    test('Tab click handler should not be registered when intersection observer is used', function () {
        this.sandbox.useFakeTimers();
        this.sandbox.spy(this.fsm, "triggerEvent");

        var tabs = $('<div id="tab" class="tabs-pane"><a href="#tab">click</a></div>');
        var button = tabs.find('a');
        var element = document.createElement('rich-editor');
        element.FSM = this.fsm;
        element.$textarea = $('<textarea></textarea>');
        tabs.append(element.$textarea);
        $('#qunit-fixture').append(tabs);

        this.StateHidden(element, element.$textarea[0]);

        sinon.assert.notCalled(this.fsm.triggerEvent);

        button.click();
        this.sandbox.clock.tick(50);

        sinon.assert.notCalled(this.fsm.triggerEvent);
    });

    test('Tab click handler should be registered when intersection observer is not used', function () {
        this.sandbox.useFakeTimers();
        this.sandbox.spy(this.fsm, "triggerEvent");
        this.stateHiddenIntersectionObserver.observe = sinon.stub().returns(false);

        var tabs = $('<div id="tab" class="tabs-pane"><a href="#tab">click</a></div>');
        var button = tabs.find('a');
        var element = document.createElement('rich-editor');
        element.FSM = this.fsm;
        element.$textarea = $('<textarea></textarea>');
        tabs.append(element.$textarea);
        $('#qunit-fixture').append(tabs);

        this.StateHidden(element, element.$textarea[0]);

        sinon.assert.notCalled(this.fsm.triggerEvent);

        button.click();
        this.sandbox.clock.tick(50);

        sinon.assert.called(this.fsm.triggerEvent);
    });

    test('Clear up should be performed after transition from state-hidden', function () {
        this.sandbox.spy(window, "clearInterval");

        var element = document.createElement('rich-editor');
        element.$textarea = $('<textarea></textarea>');
        element.FSM = this.fsm;
        //textarea.is(":visible") = true
        $('#qunit-fixture').append(element.$textarea);

        var state = this.StateHidden(element, element.$textarea[0]);
        state = state(Events.VISIBLE);

        equal(state.stateName, 'TestWrap', 'Transitioned to Wrap');

        ok(window.clearInterval.called, "window.clearInterval should be called");
        ok(this.stateHiddenIntersectionObserver.cleanup.called, "window.clearInterval should be called");
    });

    test('Detached event should move RTE to init state', function () {
        var element = document.createElement('rich-editor');
        element.$textarea = $('<textarea></textarea>');
        element.FSM = this.fsm;

        var state = this.StateHidden(element, element.$textarea[0]);
        state = state(Events.DETACHED);

        equal(state.stateName, 'Init', 'Transitioned to Init');
    });

    test('Failsafe setInterval should emit event when textarea is visible', function () {
        this.sandbox.useFakeTimers();
        this.sandbox.spy(this.fsm, "triggerEvent");

        var element = document.createElement('rich-editor');
        element.FSM = this.fsm;
        element.$textarea = $('<textarea></textarea>');
        $('#qunit-fixture').append(element.$textarea);

        this.StateHidden(element, element.$textarea[0]);

        sinon.assert.notCalled(this.fsm.triggerEvent);

        this.sandbox.clock.tick(60);
        sinon.assert.notCalled(this.fsm.triggerEvent);

        this.sandbox.clock.tick(60);
        sinon.assert.called(this.fsm.triggerEvent);
    });
});