define("jira/editor/converter/handlers/code-block-handler", [
    "jira/editor/converter/handlers/block-handler",
    "jira/editor/converter/handlers/text-handler",
    "jquery"
], function (
    BlockHandler,
    TextHandler,
    $
) {
    "use strict";

    var CodeBlockHandler = BlockHandler.extend({
        init: function CodeBlockHandler(node) {
            this._super(node);

            this.language = this.getLanguage();
        },

        getLanguage: function () {
            var pre = $(this.node).is('pre') ? this.node : this.node.querySelector('pre');
            var language = $(pre).attr("data-language");
            return language ? language.replace('code-', '') : '';
        },

        before: function () {
            var attrs = [];
            if (this.language) {
                attrs.push(this.language);
            }
            if (this.attrs) {
                attrs.push(this.attrs);
            }

            var attrs = (attrs.length) ? ':' + attrs.join('|') : '';
            return TextHandler.createPreformattedTextHandler('{code' + attrs + '}');
        },

        after: function () {
            return TextHandler.createPreformattedTextHandler('{code}');
        }
    });

    return CodeBlockHandler;
});